/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.internal.jmx;

import com.atlassian.nutcluster.instance.NutclusterInstanceImpl;
import com.atlassian.nutcluster.internal.jmx.ManagedAnnotation;
import com.atlassian.nutcluster.internal.jmx.ManagedDescription;
import com.atlassian.nutcluster.internal.jmx.ManagementService;
import com.atlassian.nutcluster.internal.jmx.NutclusterMBean;
import com.atlassian.nutcluster.internal.partition.InternalPartitionService;
import com.atlassian.nutcluster.nio.Address;
import com.atlassian.nutcluster.util.MapUtil;
import java.util.Map;

@ManagedDescription(value="NutclusterInstance.PartitionServiceMBean")
public class PartitionServiceMBean
extends NutclusterMBean<InternalPartitionService> {
    private static final int INITIAL_CAPACITY = 3;
    private final NutclusterInstanceImpl NutclusterInstance;

    public PartitionServiceMBean(NutclusterInstanceImpl NutclusterInstance2, InternalPartitionService partitionService, ManagementService service) {
        super(partitionService, service);
        this.NutclusterInstance = NutclusterInstance2;
        Map<String, String> properties = MapUtil.createHashMap(3);
        properties.put("type", ManagementService.quote("NutclusterInstance.PartitionServiceMBean"));
        properties.put("name", ManagementService.quote(NutclusterInstance2.getName()));
        properties.put("instance", ManagementService.quote(NutclusterInstance2.getName()));
        this.setObjectName(properties);
    }

    @ManagedAnnotation(value="partitionCount")
    @ManagedDescription(value="Number of partitions")
    public int getPartitionCount() {
        return ((InternalPartitionService)this.managedObject).getPartitionCount();
    }

    @ManagedAnnotation(value="activePartitionCount")
    @ManagedDescription(value="Number of active partitions")
    public int getActivePartitionCount() {
        Address thisAddress = this.NutclusterInstance.getCluster().getLocalMember().getAddress();
        return ((InternalPartitionService)this.managedObject).getMemberPartitionsIfAssigned(thisAddress).size();
    }

    @ManagedAnnotation(value="isClusterSafe")
    @ManagedDescription(value="Is the cluster in a safe state")
    public boolean isClusterSafe() {
        return this.NutclusterInstance.getPartitionService().isClusterSafe();
    }

    @ManagedAnnotation(value="isLocalMemberSafe")
    @ManagedDescription(value="Is the local member safe to shutdown")
    public boolean isLocalMemberSafe() {
        return this.NutclusterInstance.getPartitionService().isLocalMemberSafe();
    }
}

