/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.internal.jmx;

import com.atlassian.nutcluster.internal.jmx.ManagedAnnotation;
import com.atlassian.nutcluster.internal.jmx.ManagedDescription;
import com.atlassian.nutcluster.internal.jmx.ManagementService;
import com.atlassian.nutcluster.internal.jmx.NutclusterMBean;
import com.atlassian.nutcluster.monitor.LocalWanPublisherStats;
import com.atlassian.nutcluster.monitor.LocalWanStats;
import com.atlassian.nutcluster.wan.WanReplicationService;
import java.util.Map;

@ManagedDescription(value="WanReplicationPublisher")
public class WanPublisherMBean
extends NutclusterMBean<WanReplicationService> {
    private final String wanReplicationName;
    private final String targetGroupName;

    public WanPublisherMBean(WanReplicationService wanReplicationService, String wanReplicationName, String targetGroupName, ManagementService service) {
        super(wanReplicationService, service);
        this.wanReplicationName = wanReplicationName;
        this.targetGroupName = targetGroupName;
        this.objectName = service.createObjectName("WanReplicationPublisher", wanReplicationName + "." + targetGroupName);
    }

    @ManagedAnnotation(value="state")
    @ManagedDescription(value="State of the WAN replication publisher")
    public String getState() {
        Map wanStats = ((WanReplicationService)this.managedObject).getStats();
        if (wanStats == null) {
            return "";
        }
        LocalWanStats wanReplicationStats = (LocalWanStats)wanStats.get(this.wanReplicationName);
        Map<String, LocalWanPublisherStats> wanDelegatingPublisherStats = wanReplicationStats.getLocalWanPublisherStats();
        LocalWanPublisherStats wanPublisherStats = wanDelegatingPublisherStats.get(this.targetGroupName);
        return wanPublisherStats.getPublisherState().name();
    }
}

