/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.internal.management;

import com.atlassian.nutcluster.client.impl.ClientEngine;
import com.atlassian.nutcluster.client.impl.ClientSelector;
import com.atlassian.nutcluster.client.impl.ClientSelectors;
import com.atlassian.nutcluster.internal.json.JsonObject;
import com.atlassian.nutcluster.internal.management.dto.ClientBwListDTO;
import com.atlassian.nutcluster.internal.management.dto.ClientBwListEntryDTO;
import com.atlassian.nutcluster.logging.ILogger;
import com.atlassian.nutcluster.logging.Logger;
import com.atlassian.nutcluster.util.JsonUtil;
import java.util.List;
import java.util.regex.Pattern;

public class ClientBwListConfigHandler {
    private static final ILogger LOGGER = Logger.getLogger(ClientBwListConfigHandler.class);
    private final ClientEngine clientEngine;

    public ClientBwListConfigHandler(ClientEngine clientEngine) {
        this.clientEngine = clientEngine;
    }

    public void handleLostConnection() {
        try {
            this.clientEngine.applySelector(ClientSelectors.any());
        }
        catch (Exception e) {
            LOGGER.warning("Could not clean up client B/W list filtering.", e);
        }
    }

    public void handleConfig(JsonObject configJson) {
        try {
            JsonObject bwListConfigJson = JsonUtil.getObject(configJson, "clientBwList");
            ClientBwListDTO configDTO = new ClientBwListDTO();
            configDTO.fromJson(bwListConfigJson);
            this.applyConfig(configDTO);
        }
        catch (Exception e) {
            LOGGER.warning("Could not apply client B/W list filtering.", e);
        }
    }

    private void applyConfig(ClientBwListDTO configDTO) {
        ClientSelector selector = null;
        switch (configDTO.mode) {
            case DISABLED: {
                selector = ClientSelectors.any();
                break;
            }
            case WHITELIST: {
                selector = ClientBwListConfigHandler.createSelector(configDTO.entries);
                break;
            }
            case BLACKLIST: {
                selector = ClientSelectors.inverse(ClientBwListConfigHandler.createSelector(configDTO.entries));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown client B/W list mode: " + String.valueOf((Object)configDTO.mode));
            }
        }
        this.clientEngine.applySelector(selector);
    }

    private static ClientSelector createSelector(List<ClientBwListEntryDTO> entries) {
        ClientSelector selector = ClientSelectors.none();
        for (ClientBwListEntryDTO entryDTO : entries) {
            ClientSelector entrySelector = ClientBwListConfigHandler.createSelector(entryDTO);
            selector = ClientSelectors.or(selector, entrySelector);
        }
        return selector;
    }

    private static ClientSelector createSelector(ClientBwListEntryDTO entry) {
        switch (entry.type) {
            case IP_ADDRESS: {
                return ClientSelectors.ipSelector(entry.value);
            }
            case INSTANCE_NAME: {
                return ClientSelectors.nameSelector(ClientBwListConfigHandler.sanitizeValueWithWildcards(entry.value));
            }
            case LABEL: {
                return ClientSelectors.labelSelector(ClientBwListConfigHandler.sanitizeValueWithWildcards(entry.value));
            }
        }
        throw new IllegalArgumentException("Unknown client B/W list entry type: " + String.valueOf((Object)entry.type));
    }

    private static String sanitizeValueWithWildcards(String value) {
        String quoted = Pattern.quote(value);
        return quoted.replaceAll("\\*", "\\\\E.*\\\\Q");
    }
}

