/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.internal.management.request;

import com.atlassian.nutcluster.cluster.ClusterState;
import com.atlassian.nutcluster.core.Cluster;
import com.atlassian.nutcluster.internal.json.JsonObject;
import com.atlassian.nutcluster.internal.management.ManagementCenterService;
import com.atlassian.nutcluster.internal.management.request.AsyncConsoleRequest;
import com.atlassian.nutcluster.logging.ILogger;
import com.atlassian.nutcluster.util.JsonUtil;

public class ChangeClusterStateRequest
implements AsyncConsoleRequest {
    private static final String FAILURE = "FAILURE: ";
    private String state;

    public ChangeClusterStateRequest() {
    }

    public ChangeClusterStateRequest(String state) {
        this.state = state;
    }

    @Override
    public int getType() {
        return 35;
    }

    @Override
    public void writeResponse(ManagementCenterService mcs, JsonObject out) throws Exception {
        Object resultString = "SUCCESS";
        try {
            Cluster cluster = mcs.getNutclusterInstance().getCluster();
            cluster.changeClusterState(ChangeClusterStateRequest.getClusterState(this.state));
        }
        catch (Exception e) {
            ILogger logger = mcs.getNutclusterInstance().node.nodeEngine.getLogger(this.getClass());
            logger.warning("Cluster state can not be changed: ", e);
            resultString = FAILURE + e.getMessage();
        }
        JsonObject result = new JsonObject().add("result", (String)resultString);
        out.add("result", result);
    }

    private static ClusterState getClusterState(String state) {
        return ClusterState.valueOf(state);
    }

    @Override
    public void fromJson(JsonObject json) {
        this.state = JsonUtil.getString(json, "state");
    }
}

