/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.internal.management.request;

import com.atlassian.nutcluster.config.MapConfig;
import com.atlassian.nutcluster.core.Member;
import com.atlassian.nutcluster.internal.json.JsonObject;
import com.atlassian.nutcluster.internal.management.ManagementCenterService;
import com.atlassian.nutcluster.internal.management.dto.MapConfigDTO;
import com.atlassian.nutcluster.internal.management.operation.GetMapConfigOperation;
import com.atlassian.nutcluster.internal.management.operation.UpdateMapConfigOperation;
import com.atlassian.nutcluster.internal.management.request.ConsoleRequest;
import com.atlassian.nutcluster.util.JsonUtil;
import java.util.Set;

public class MapConfigRequest
implements ConsoleRequest {
    private String mapName;
    private MapConfigDTO config;
    private boolean update;

    public MapConfigRequest() {
    }

    public MapConfigRequest(String mapName, MapConfigDTO config, boolean update) {
        this.mapName = mapName;
        this.config = config;
        this.update = update;
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public void writeResponse(ManagementCenterService mcs, JsonObject root) {
        JsonObject result = new JsonObject();
        result.add("update", this.update);
        if (this.update) {
            Set<Member> members = mcs.getNutclusterInstance().getCluster().getMembers();
            for (Member member : members) {
                ManagementCenterService.resolveFuture(mcs.callOnMember(member, new UpdateMapConfigOperation(this.mapName, this.config.getMapConfig())));
            }
            result.add("updateResult", "success");
        } else {
            MapConfig cfg = (MapConfig)ManagementCenterService.resolveFuture(mcs.callOnThis(new GetMapConfigOperation(this.mapName)));
            if (cfg != null) {
                result.add("hasMapConfig", true);
                result.add("mapConfig", new MapConfigDTO(cfg).toJson());
            } else {
                result.add("hasMapConfig", false);
            }
        }
        root.add("result", result);
    }

    @Override
    public void fromJson(JsonObject json) {
        this.mapName = JsonUtil.getString(json, "mapName");
        this.update = JsonUtil.getBoolean(json, "update");
        this.config = new MapConfigDTO();
        this.config.fromJson(JsonUtil.getObject(json, "config"));
    }
}

