/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.internal.management.request;

import com.atlassian.nutcluster.internal.json.JsonObject;
import com.atlassian.nutcluster.internal.management.ManagementCenterService;
import com.atlassian.nutcluster.internal.management.operation.ThreadDumpOperation;
import com.atlassian.nutcluster.internal.management.request.ConsoleRequest;
import com.atlassian.nutcluster.spi.InternalCompletableFuture;
import com.atlassian.nutcluster.util.ExceptionUtil;
import com.atlassian.nutcluster.util.JsonUtil;
import java.util.concurrent.ExecutionException;

public class ThreadDumpRequest
implements ConsoleRequest {
    private boolean dumpDeadlocks;

    public ThreadDumpRequest() {
    }

    public ThreadDumpRequest(boolean dumpDeadlocks) {
        this.dumpDeadlocks = dumpDeadlocks;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public void writeResponse(ManagementCenterService mcs, JsonObject root) {
        JsonObject result = new JsonObject();
        InternalCompletableFuture<Object> future = mcs.callOnThis(new ThreadDumpOperation(this.dumpDeadlocks));
        try {
            String threadDump = (String)future.get();
            if (threadDump != null) {
                result.add("hasDump", true);
                result.add("dump", threadDump);
            } else {
                result.add("hasDump", false);
            }
        }
        catch (ExecutionException e) {
            ThreadDumpRequest.addError(result, e);
        }
        catch (InterruptedException e) {
            ThreadDumpRequest.addError(result, e);
            Thread.currentThread().interrupt();
        }
        root.add("result", result);
    }

    @Override
    public void fromJson(JsonObject json) {
        this.dumpDeadlocks = JsonUtil.getBoolean(json, "dumpDeadlocks", false);
    }

    private static void addError(JsonObject root, Exception e) {
        root.add("hasDump", false);
        root.add("error", ExceptionUtil.toString(e));
    }
}

