/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.internal.partition;

import com.atlassian.nutcluster.logging.ILogger;
import com.atlassian.nutcluster.spi.exception.CallerNotMemberException;
import com.atlassian.nutcluster.spi.exception.PartitionMigratingException;
import com.atlassian.nutcluster.spi.exception.RetryableException;
import com.atlassian.nutcluster.spi.exception.TargetNotMemberException;
import com.atlassian.nutcluster.spi.exception.WrongTargetException;
import java.util.logging.Level;

public final class ReplicaErrorLogger {
    private ReplicaErrorLogger() {
    }

    public static void log(Throwable e, ILogger logger) {
        if (e instanceof RetryableException) {
            Level level = Level.INFO;
            if (e instanceof CallerNotMemberException || e instanceof WrongTargetException || e instanceof TargetNotMemberException || e instanceof PartitionMigratingException) {
                level = Level.FINEST;
            }
            if (logger.isLoggable(level)) {
                logger.log(level, e.toString());
            }
        } else {
            logger.warning(e);
        }
    }
}

