/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.internal.partition.operation;

import com.atlassian.nutcluster.instance.MemberImpl;
import com.atlassian.nutcluster.internal.cluster.ClusterService;
import com.atlassian.nutcluster.internal.partition.MigrationCycleOperation;
import com.atlassian.nutcluster.internal.partition.impl.InternalPartitionServiceImpl;
import com.atlassian.nutcluster.internal.partition.operation.AbstractPartitionOperation;
import com.atlassian.nutcluster.logging.ILogger;
import com.atlassian.nutcluster.nio.Address;

public class ShutdownRequestOperation
extends AbstractPartitionOperation
implements MigrationCycleOperation {
    @Override
    public void run() {
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        ILogger logger = this.getLogger();
        Address caller = this.getCallerAddress();
        if (partitionService.isLocalMemberMaster()) {
            ClusterService clusterService = this.getNodeEngine().getClusterService();
            MemberImpl member = clusterService.getMember(caller);
            if (member != null) {
                if (logger.isFinestEnabled()) {
                    logger.finest("Received shutdown request from " + String.valueOf(caller));
                }
                partitionService.onShutdownRequest(member);
            } else {
                logger.warning("Ignoring shutdown request from " + String.valueOf(caller) + " because it is not a member");
            }
        } else {
            logger.warning("Received shutdown request from " + String.valueOf(caller) + " but this node is not master.");
        }
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }

    @Override
    public int getId() {
        return 15;
    }
}

