/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.internal.serialization.impl;

import com.atlassian.nutcluster.internal.serialization.InputOutputFactory;
import com.atlassian.nutcluster.internal.serialization.InternalSerializationService;
import com.atlassian.nutcluster.internal.serialization.impl.ByteArrayObjectDataInput;
import com.atlassian.nutcluster.internal.serialization.impl.ByteArrayObjectDataOutput;
import com.atlassian.nutcluster.nio.BufferObjectDataInput;
import com.atlassian.nutcluster.nio.BufferObjectDataOutput;
import com.atlassian.nutcluster.nio.serialization.Data;
import java.nio.ByteOrder;

final class ByteArrayInputOutputFactory
implements InputOutputFactory {
    private final ByteOrder byteOrder;

    public ByteArrayInputOutputFactory(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    @Override
    public BufferObjectDataInput createInput(Data data, InternalSerializationService service) {
        return new ByteArrayObjectDataInput(data.toByteArray(), 8, service, this.byteOrder);
    }

    @Override
    public BufferObjectDataInput createInput(byte[] buffer, InternalSerializationService service) {
        return new ByteArrayObjectDataInput(buffer, service, this.byteOrder);
    }

    @Override
    public BufferObjectDataOutput createOutput(int size, InternalSerializationService service) {
        return new ByteArrayObjectDataOutput(size, service, this.byteOrder);
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }
}

