/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.map.impl;

import com.atlassian.nutcluster.core.EntryEventType;
import com.atlassian.nutcluster.core.EntryListener;
import com.atlassian.nutcluster.core.IMapEvent;
import com.atlassian.nutcluster.map.impl.EntryListenerAdaptors;
import com.atlassian.nutcluster.map.impl.ListenerAdapter;
import com.atlassian.nutcluster.util.Preconditions;

class InternalEntryListenerAdapter
implements ListenerAdapter<IMapEvent> {
    private final ListenerAdapter[] listenerAdapters;

    InternalEntryListenerAdapter(EntryListener listener) {
        Preconditions.isNotNull(listener, "listener");
        this.listenerAdapters = EntryListenerAdaptors.createListenerAdapters(listener);
    }

    @Override
    public void onEvent(IMapEvent event) {
        EntryEventType eventType = event.getEventType();
        ListenerAdapter listenerAdapter = this.listenerAdapters[eventType.ordinal()];
        if (listenerAdapter == null) {
            return;
        }
        listenerAdapter.onEvent(event);
    }
}

