/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.map.impl;

import com.atlassian.nutcluster.core.DistributedObject;
import com.atlassian.nutcluster.map.impl.MapServiceContext;
import com.atlassian.nutcluster.map.impl.proxy.MapProxyImpl;
import com.atlassian.nutcluster.nio.Address;
import com.atlassian.nutcluster.spi.NodeEngine;
import com.atlassian.nutcluster.spi.PartitionAwareService;
import com.atlassian.nutcluster.spi.ProxyService;
import com.atlassian.nutcluster.spi.partition.IPartitionLostEvent;
import java.util.Collection;

class MapPartitionAwareService
implements PartitionAwareService {
    private final MapServiceContext mapServiceContext;
    private final NodeEngine nodeEngine;
    private final ProxyService proxyService;

    public MapPartitionAwareService(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = mapServiceContext.getNodeEngine();
        this.proxyService = this.nodeEngine.getProxyService();
    }

    @Override
    public void onPartitionLost(IPartitionLostEvent partitionLostEvent) {
        Address thisAddress = this.nodeEngine.getThisAddress();
        int partitionId = partitionLostEvent.getPartitionId();
        Collection<DistributedObject> result = this.proxyService.getDistributedObjects("hz:impl:mapService");
        for (DistributedObject object : result) {
            MapProxyImpl mapProxy = (MapProxyImpl)object;
            String mapName = mapProxy.getName();
            if (mapProxy.getTotalBackupCount() > partitionLostEvent.getLostReplicaIndex()) continue;
            this.mapServiceContext.getMapEventPublisher().publishMapPartitionLostEvent(thisAddress, mapName, partitionId);
        }
    }
}

