/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.map.impl;

import com.atlassian.nutcluster.map.impl.MapContainer;
import com.atlassian.nutcluster.map.impl.MapServiceContext;
import com.atlassian.nutcluster.spi.QuorumAwareService;
import com.atlassian.nutcluster.util.ConcurrencyUtil;
import com.atlassian.nutcluster.util.ConstructorFunction;
import com.atlassian.nutcluster.util.ContextMutexFactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MapQuorumAwareService
implements QuorumAwareService {
    private static final Object NULL_OBJECT = new Object();
    private final MapServiceContext mapServiceContext;
    private final ConcurrentMap<String, Object> quorumConfigCache = new ConcurrentHashMap<String, Object>();
    private final ContextMutexFactory quorumConfigCacheMutexFactory = new ContextMutexFactory();
    private final ConstructorFunction<String, Object> quorumConfigConstructor = new ConstructorFunction<String, Object>(){

        @Override
        public Object createNew(String name) {
            MapContainer mapContainer = MapQuorumAwareService.this.mapServiceContext.getMapContainer(name);
            String quorumName = mapContainer.getQuorumName();
            return quorumName == null ? NULL_OBJECT : quorumName;
        }
    };

    public MapQuorumAwareService(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
    }

    @Override
    public String getQuorumName(String name) {
        Object quorumName = ConcurrencyUtil.getOrPutSynchronized(this.quorumConfigCache, name, this.quorumConfigCacheMutexFactory, this.quorumConfigConstructor);
        return quorumName == NULL_OBJECT ? null : (String)quorumName;
    }

    public void onDestroy(String name) {
        this.quorumConfigCache.remove(name);
    }
}

