/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.map.impl;

import com.atlassian.nutcluster.cluster.ClusterState;
import com.atlassian.nutcluster.core.DistributedObject;
import com.atlassian.nutcluster.core.EntryEventType;
import com.atlassian.nutcluster.internal.cluster.ClusterStateListener;
import com.atlassian.nutcluster.map.impl.EventListenerFilter;
import com.atlassian.nutcluster.map.impl.ListenerAdapter;
import com.atlassian.nutcluster.map.impl.MapContainer;
import com.atlassian.nutcluster.map.impl.MapQuorumAwareService;
import com.atlassian.nutcluster.map.impl.MapServiceContext;
import com.atlassian.nutcluster.map.impl.recordstore.RecordStore;
import com.atlassian.nutcluster.monitor.LocalMapStats;
import com.atlassian.nutcluster.nio.serialization.Data;
import com.atlassian.nutcluster.spi.ClientAwareService;
import com.atlassian.nutcluster.spi.DistributedObjectNamespace;
import com.atlassian.nutcluster.spi.EventFilter;
import com.atlassian.nutcluster.spi.EventPublishingService;
import com.atlassian.nutcluster.spi.EventRegistration;
import com.atlassian.nutcluster.spi.FragmentedMigrationAwareService;
import com.atlassian.nutcluster.spi.LockInterceptorService;
import com.atlassian.nutcluster.spi.ManagedService;
import com.atlassian.nutcluster.spi.NodeEngine;
import com.atlassian.nutcluster.spi.NotifiableEventListener;
import com.atlassian.nutcluster.spi.ObjectNamespace;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.spi.PartitionAwareService;
import com.atlassian.nutcluster.spi.PartitionMigrationEvent;
import com.atlassian.nutcluster.spi.PartitionReplicationEvent;
import com.atlassian.nutcluster.spi.PostJoinAwareService;
import com.atlassian.nutcluster.spi.QuorumAwareService;
import com.atlassian.nutcluster.spi.RemoteService;
import com.atlassian.nutcluster.spi.ReplicationSupportingService;
import com.atlassian.nutcluster.spi.ServiceNamespace;
import com.atlassian.nutcluster.spi.SplitBrainHandlerService;
import com.atlassian.nutcluster.spi.StatisticsAwareService;
import com.atlassian.nutcluster.spi.TransactionalService;
import com.atlassian.nutcluster.spi.impl.CountingMigrationAwareService;
import com.atlassian.nutcluster.spi.partition.IPartitionLostEvent;
import com.atlassian.nutcluster.transaction.TransactionalObject;
import com.atlassian.nutcluster.transaction.impl.Transaction;
import com.atlassian.nutcluster.wan.WanReplicationEvent;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;

public class MapService
implements ManagedService,
FragmentedMigrationAwareService,
TransactionalService,
RemoteService,
EventPublishingService<Object, ListenerAdapter>,
PostJoinAwareService,
SplitBrainHandlerService,
ReplicationSupportingService,
StatisticsAwareService<LocalMapStats>,
PartitionAwareService,
ClientAwareService,
QuorumAwareService,
NotifiableEventListener,
ClusterStateListener,
LockInterceptorService<Data> {
    public static final String SERVICE_NAME = "hz:impl:mapService";
    protected ManagedService managedService;
    protected CountingMigrationAwareService migrationAwareService;
    protected TransactionalService transactionalService;
    protected RemoteService remoteService;
    protected EventPublishingService eventPublishingService;
    protected PostJoinAwareService postJoinAwareService;
    protected SplitBrainHandlerService splitBrainHandlerService;
    protected ReplicationSupportingService replicationSupportingService;
    protected StatisticsAwareService statisticsAwareService;
    protected PartitionAwareService partitionAwareService;
    protected ClientAwareService clientAwareService;
    protected MapQuorumAwareService quorumAwareService;
    protected MapServiceContext mapServiceContext;

    @Override
    public void dispatchEvent(Object event, ListenerAdapter listener) {
        this.eventPublishingService.dispatchEvent(event, listener);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.managedService.init(nodeEngine, properties);
    }

    @Override
    public void reset() {
        this.managedService.reset();
    }

    @Override
    public void shutdown(boolean terminate) {
        this.managedService.shutdown(terminate);
    }

    @Override
    public Collection<ServiceNamespace> getAllServiceNamespaces(PartitionReplicationEvent event) {
        return this.migrationAwareService.getAllServiceNamespaces(event);
    }

    @Override
    public boolean isKnownServiceNamespace(ServiceNamespace namespace) {
        return this.migrationAwareService.isKnownServiceNamespace(namespace);
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        return this.migrationAwareService.prepareReplicationOperation(event);
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event, Collection<ServiceNamespace> namespaces) {
        return this.migrationAwareService.prepareReplicationOperation(event, namespaces);
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent event) {
        this.migrationAwareService.beforeMigration(event);
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        this.migrationAwareService.commitMigration(event);
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        this.migrationAwareService.rollbackMigration(event);
    }

    @Override
    public Operation getPostJoinOperation() {
        return this.postJoinAwareService.getPostJoinOperation();
    }

    @Override
    public DistributedObject createDistributedObject(String objectName) {
        return this.remoteService.createDistributedObject(objectName);
    }

    @Override
    public void destroyDistributedObject(String objectName) {
        this.remoteService.destroyDistributedObject(objectName);
        this.quorumAwareService.onDestroy(objectName);
    }

    @Override
    public void onReplicationEvent(WanReplicationEvent replicationEvent) {
        this.replicationSupportingService.onReplicationEvent(replicationEvent);
    }

    @Override
    public void onPartitionLost(IPartitionLostEvent partitionLostEvent) {
        this.partitionAwareService.onPartitionLost(partitionLostEvent);
    }

    @Override
    public Runnable prepareMergeRunnable() {
        return this.splitBrainHandlerService.prepareMergeRunnable();
    }

    @Override
    public <T extends TransactionalObject> T createTransactionalObject(String name, Transaction transaction) {
        return this.transactionalService.createTransactionalObject(name, transaction);
    }

    @Override
    public void rollbackTransaction(String transactionId) {
        this.transactionalService.rollbackTransaction(transactionId);
    }

    @Override
    public Map<String, LocalMapStats> getStats() {
        return this.statisticsAwareService.getStats();
    }

    @Override
    public String getQuorumName(String name) {
        return this.quorumAwareService.getQuorumName(name);
    }

    public MapServiceContext getMapServiceContext() {
        return this.mapServiceContext;
    }

    @Override
    public void clientDisconnected(String clientUuid) {
        this.clientAwareService.clientDisconnected(clientUuid);
    }

    public void onRegister(Object service, String serviceName, String topic, EventRegistration registration) {
        EventFilter filter = registration.getFilter();
        if (!(filter instanceof EventListenerFilter) || !filter.eval(EntryEventType.INVALIDATION.getType())) {
            return;
        }
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(topic);
        mapContainer.increaseInvalidationListenerCount();
    }

    public void onDeregister(Object service, String serviceName, String topic, EventRegistration registration) {
        EventFilter filter = registration.getFilter();
        if (!(filter instanceof EventListenerFilter) || !filter.eval(EntryEventType.INVALIDATION.getType())) {
            return;
        }
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(topic);
        mapContainer.decreaseInvalidationListenerCount();
    }

    public int getMigrationStamp() {
        return this.migrationAwareService.getMigrationStamp();
    }

    public boolean validateMigrationStamp(int stamp) {
        return this.migrationAwareService.validateMigrationStamp(stamp);
    }

    @Override
    public void onClusterStateChange(ClusterState newState) {
        this.mapServiceContext.onClusterStateChange(newState);
    }

    @Override
    public void onBeforeLock(String distributedObjectName, Data key) {
        int partitionId = this.mapServiceContext.getNodeEngine().getPartitionService().getPartitionId(key);
        RecordStore recordStore = this.mapServiceContext.getRecordStore(partitionId, distributedObjectName);
        recordStore.getRecordOrNull(key);
    }

    public static ObjectNamespace getObjectNamespace(String mapName) {
        return new DistributedObjectNamespace(SERVICE_NAME, mapName);
    }
}

