/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.map.impl.iterator;

import com.atlassian.nutcluster.map.impl.iterator.AbstractCursor;
import com.atlassian.nutcluster.map.impl.iterator.AbstractMapPartitionIterator;
import com.atlassian.nutcluster.map.impl.operation.MapOperation;
import com.atlassian.nutcluster.map.impl.operation.MapOperationProvider;
import com.atlassian.nutcluster.map.impl.proxy.MapProxyImpl;
import com.atlassian.nutcluster.spi.InternalCompletableFuture;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.spi.serialization.SerializationService;
import java.util.List;

public class MapPartitionIterator<K, V>
extends AbstractMapPartitionIterator<K, V> {
    private final MapProxyImpl<K, V> mapProxy;

    public MapPartitionIterator(MapProxyImpl<K, V> mapProxy, int fetchSize, int partitionId, boolean prefetchValues) {
        super(mapProxy, fetchSize, partitionId, prefetchValues);
        this.mapProxy = mapProxy;
        this.advance();
    }

    @Override
    protected List fetch() {
        String name = this.mapProxy.getName();
        MapOperationProvider operationProvider = this.mapProxy.getOperationProvider();
        MapOperation operation = this.prefetchValues ? operationProvider.createFetchEntriesOperation(name, this.lastTableIndex, this.fetchSize) : operationProvider.createFetchKeysOperation(name, this.lastTableIndex, this.fetchSize);
        Object cursor = this.invoke(operation);
        this.setLastTableIndex(((AbstractCursor)cursor).getBatch(), ((AbstractCursor)cursor).getNextTableIndexToReadFrom());
        return ((AbstractCursor)cursor).getBatch();
    }

    private <T extends AbstractCursor> T invoke(Operation operation) {
        InternalCompletableFuture future = this.mapProxy.getOperationService().invokeOnPartition(this.mapProxy.getServiceName(), operation, this.partitionId);
        return (T)((AbstractCursor)future.join());
    }

    @Override
    protected SerializationService getSerializationService() {
        return this.mapProxy.getNodeEngine().getSerializationService();
    }
}

