/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.map.impl.journal;

import com.atlassian.nutcluster.core.EntryEventType;
import com.atlassian.nutcluster.internal.journal.DeserializingEntry;
import com.atlassian.nutcluster.map.impl.journal.DeserializingEventJournalMapEvent;
import com.atlassian.nutcluster.map.journal.EventJournalMapEvent;
import com.atlassian.nutcluster.nio.serialization.SerializableByConvention;
import com.atlassian.nutcluster.util.function.Function;
import com.atlassian.nutcluster.util.function.Predicate;
import java.io.Serializable;
import java.util.Map;

public final class MapEventJournalFunctions {
    private MapEventJournalFunctions() {
    }

    public static <K, V> Predicate<EventJournalMapEvent<K, V>> mapPutEvents() {
        return new MapPutEventsPredicate();
    }

    public static <K, V> Function<EventJournalMapEvent<K, V>, Map.Entry<K, V>> mapEventToEntry() {
        return new MapEventToEntryProjection();
    }

    public static <K, V> Function<EventJournalMapEvent<K, V>, V> mapEventNewValue() {
        return new MapEventNewValueProjection();
    }

    @SerializableByConvention
    private static class MapPutEventsPredicate<K, V>
    implements Predicate<EventJournalMapEvent<K, V>>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private MapPutEventsPredicate() {
        }

        @Override
        public boolean test(EventJournalMapEvent<K, V> e) {
            return e.getType() == EntryEventType.ADDED || e.getType() == EntryEventType.UPDATED;
        }
    }

    @SerializableByConvention
    private static class MapEventToEntryProjection<K, V>
    implements Function<EventJournalMapEvent<K, V>, Map.Entry<K, V>>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private MapEventToEntryProjection() {
        }

        @Override
        public Map.Entry<K, V> apply(EventJournalMapEvent<K, V> e) {
            DeserializingEventJournalMapEvent casted = (DeserializingEventJournalMapEvent)e;
            return new DeserializingEntry(casted.getDataKey(), casted.getDataNewValue());
        }
    }

    @SerializableByConvention
    private static class MapEventNewValueProjection
    implements Function,
    Serializable {
        private static final long serialVersionUID = 1L;

        private MapEventNewValueProjection() {
        }

        public Object apply(Object event) {
            DeserializingEventJournalMapEvent casted = (DeserializingEventJournalMapEvent)event;
            return casted.getDataNewValue();
        }
    }
}

