/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.map.impl.nearcache;

import com.atlassian.nutcluster.core.EntryEventType;
import com.atlassian.nutcluster.core.IFunction;
import com.atlassian.nutcluster.internal.cluster.ClusterService;
import com.atlassian.nutcluster.internal.nearcache.NearCache;
import com.atlassian.nutcluster.internal.nearcache.impl.DefaultNearCacheManager;
import com.atlassian.nutcluster.internal.nearcache.impl.invalidation.BatchInvalidator;
import com.atlassian.nutcluster.internal.nearcache.impl.invalidation.Invalidator;
import com.atlassian.nutcluster.internal.nearcache.impl.invalidation.MinimalPartitionService;
import com.atlassian.nutcluster.internal.nearcache.impl.invalidation.NonStopInvalidator;
import com.atlassian.nutcluster.internal.nearcache.impl.invalidation.RepairingHandler;
import com.atlassian.nutcluster.internal.nearcache.impl.invalidation.RepairingTask;
import com.atlassian.nutcluster.logging.ILogger;
import com.atlassian.nutcluster.map.impl.EventListenerFilter;
import com.atlassian.nutcluster.map.impl.MapServiceContext;
import com.atlassian.nutcluster.map.impl.nearcache.MemberMinimalPartitionService;
import com.atlassian.nutcluster.map.impl.nearcache.invalidation.MemberMapInvalidationMetaDataFetcher;
import com.atlassian.nutcluster.nio.serialization.SerializableByConvention;
import com.atlassian.nutcluster.spi.EventFilter;
import com.atlassian.nutcluster.spi.EventRegistration;
import com.atlassian.nutcluster.spi.ExecutionService;
import com.atlassian.nutcluster.spi.NodeEngine;
import com.atlassian.nutcluster.spi.OperationService;
import com.atlassian.nutcluster.spi.properties.GroupProperty;
import com.atlassian.nutcluster.spi.properties.NutclusterProperties;

public class MapNearCacheManager
extends DefaultNearCacheManager {
    private static final InvalidationAcceptorFilter INVALIDATION_ACCEPTOR = new InvalidationAcceptorFilter();
    protected final int partitionCount;
    protected final NodeEngine nodeEngine;
    protected final MapServiceContext mapServiceContext;
    protected final MinimalPartitionService partitionService;
    protected final Invalidator invalidator;
    protected final RepairingTask repairingTask;

    public MapNearCacheManager(MapServiceContext mapServiceContext) {
        super(mapServiceContext.getNodeEngine().getSerializationService(), mapServiceContext.getNodeEngine().getExecutionService().getGlobalTaskScheduler(), null, mapServiceContext.getNodeEngine().getProperties());
        this.nodeEngine = mapServiceContext.getNodeEngine();
        this.mapServiceContext = mapServiceContext;
        this.partitionService = new MemberMinimalPartitionService(this.nodeEngine.getPartitionService());
        this.partitionCount = this.partitionService.getPartitionCount();
        this.invalidator = this.createInvalidator();
        this.repairingTask = this.createRepairingInvalidationTask();
    }

    private Invalidator createInvalidator() {
        boolean batchingEnabled;
        NutclusterProperties nutclusterProperties = this.nodeEngine.getProperties();
        int batchSize = nutclusterProperties.getInteger(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_SIZE);
        int batchFrequencySeconds = nutclusterProperties.getInteger(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_FREQUENCY_SECONDS);
        boolean bl = batchingEnabled = nutclusterProperties.getBoolean(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_ENABLED) && batchSize > 1;
        if (batchingEnabled) {
            return new BatchInvalidator("hz:impl:mapService", batchSize, batchFrequencySeconds, INVALIDATION_ACCEPTOR, this.nodeEngine);
        }
        return new NonStopInvalidator("hz:impl:mapService", INVALIDATION_ACCEPTOR, this.nodeEngine);
    }

    private RepairingTask createRepairingInvalidationTask() {
        ExecutionService executionService = this.nodeEngine.getExecutionService();
        ClusterService clusterService = this.nodeEngine.getClusterService();
        OperationService operationService = this.nodeEngine.getOperationService();
        NutclusterProperties properties = this.nodeEngine.getProperties();
        ILogger metadataFetcherLogger = this.nodeEngine.getLogger(MemberMapInvalidationMetaDataFetcher.class);
        MemberMapInvalidationMetaDataFetcher invalidationMetaDataFetcher = new MemberMapInvalidationMetaDataFetcher(clusterService, operationService, metadataFetcherLogger);
        ILogger repairingTaskLogger = this.nodeEngine.getLogger(RepairingTask.class);
        String localUuid = this.nodeEngine.getLocalMember().getUuid();
        return new RepairingTask(properties, invalidationMetaDataFetcher, executionService.getGlobalTaskScheduler(), this.serializationService, this.partitionService, localUuid, repairingTaskLogger);
    }

    public void reset() {
        this.clearAllNearCaches();
        this.invalidator.reset();
    }

    public void shutdown() {
        this.destroyAllNearCaches();
        this.invalidator.shutdown();
    }

    @Override
    public boolean destroyNearCache(String mapName) {
        this.invalidator.destroy(mapName, this.nodeEngine.getLocalMember().getUuid());
        return super.destroyNearCache(mapName);
    }

    public Invalidator getInvalidator() {
        return this.invalidator;
    }

    public RepairingHandler newRepairingHandler(String name, NearCache nearCache) {
        return this.repairingTask.registerAndGetHandler(name, nearCache);
    }

    public void deregisterRepairingHandler(String name) {
        this.repairingTask.deregisterHandler(name);
    }

    public RepairingTask getRepairingTask() {
        return this.repairingTask;
    }

    @SerializableByConvention
    private static class InvalidationAcceptorFilter
    implements IFunction<EventRegistration, Boolean> {
        private InvalidationAcceptorFilter() {
        }

        @Override
        public Boolean apply(EventRegistration eventRegistration) {
            EventFilter filter = eventRegistration.getFilter();
            return filter instanceof EventListenerFilter && filter.eval(EntryEventType.INVALIDATION.getType());
        }
    }
}

