/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.map.impl.operation;

import com.atlassian.nutcluster.config.MapConfig;
import com.atlassian.nutcluster.map.impl.MapContainer;
import com.atlassian.nutcluster.map.impl.MapServiceContext;
import com.atlassian.nutcluster.map.impl.operation.DefaultMapOperationProvider;
import com.atlassian.nutcluster.map.impl.operation.MapOperationProvider;
import com.atlassian.nutcluster.map.impl.operation.WANAwareOperationProvider;

public class MapOperationProviders {
    protected final MapServiceContext mapServiceContext;
    protected final MapOperationProvider wanAwareProvider;
    protected final MapOperationProvider defaultProvider = new DefaultMapOperationProvider();

    public MapOperationProviders(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.wanAwareProvider = new WANAwareOperationProvider(mapServiceContext, this.defaultProvider);
    }

    public MapOperationProvider getOperationProvider(String name) {
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(name);
        return mapContainer.isWanReplicationEnabled() ? this.wanAwareProvider : this.defaultProvider;
    }

    public MapOperationProvider getOperationProvider(MapConfig mapConfig) {
        if (mapConfig.getWanReplicationRef() == null) {
            return this.defaultProvider;
        }
        return this.wanAwareProvider;
    }
}

