/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.map.impl.operation;

import com.atlassian.nutcluster.map.impl.MapDataSerializerHook;
import com.atlassian.nutcluster.map.impl.MapService;
import com.atlassian.nutcluster.map.impl.MapServiceContext;
import com.atlassian.nutcluster.map.impl.PartitionContainer;
import com.atlassian.nutcluster.map.impl.operation.MapNearCacheStateHolder;
import com.atlassian.nutcluster.map.impl.operation.MapReplicationStateHolder;
import com.atlassian.nutcluster.map.impl.operation.WriteBehindStateHolder;
import com.atlassian.nutcluster.map.impl.record.Record;
import com.atlassian.nutcluster.map.impl.record.RecordInfo;
import com.atlassian.nutcluster.map.impl.record.RecordReplicationInfo;
import com.atlassian.nutcluster.map.impl.record.Records;
import com.atlassian.nutcluster.map.impl.recordstore.RecordStore;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.nio.serialization.Data;
import com.atlassian.nutcluster.nio.serialization.IdentifiedDataSerializable;
import com.atlassian.nutcluster.nio.serialization.impl.Versioned;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.spi.ServiceNamespace;
import com.atlassian.nutcluster.spi.serialization.SerializationService;
import java.io.IOException;
import java.util.Collection;

public class MapReplicationOperation
extends Operation
implements IdentifiedDataSerializable,
Versioned {
    protected final MapReplicationStateHolder mapReplicationStateHolder = new MapReplicationStateHolder(this);
    protected final WriteBehindStateHolder writeBehindStateHolder = new WriteBehindStateHolder(this);
    protected final MapNearCacheStateHolder mapNearCacheStateHolder = new MapNearCacheStateHolder(this);

    public MapReplicationOperation() {
    }

    public MapReplicationOperation(PartitionContainer container, int partitionId, int replicaIndex) {
        this.setPartitionId(partitionId).setReplicaIndex(replicaIndex);
        Collection<ServiceNamespace> namespaces = container.getAllNamespaces(replicaIndex);
        this.mapReplicationStateHolder.prepare(container, namespaces, replicaIndex);
        this.writeBehindStateHolder.prepare(container, namespaces, replicaIndex);
        this.mapNearCacheStateHolder.prepare(container, namespaces, replicaIndex);
    }

    public MapReplicationOperation(PartitionContainer container, Collection<ServiceNamespace> namespaces, int partitionId, int replicaIndex) {
        this.setPartitionId(partitionId).setReplicaIndex(replicaIndex);
        this.mapReplicationStateHolder.prepare(container, namespaces, replicaIndex);
        this.writeBehindStateHolder.prepare(container, namespaces, replicaIndex);
        this.mapNearCacheStateHolder.prepare(container, namespaces, replicaIndex);
    }

    @Override
    public void run() {
        this.mapReplicationStateHolder.applyState();
        this.writeBehindStateHolder.applyState();
        if (this.getReplicaIndex() == 0) {
            this.mapNearCacheStateHolder.applyState();
        }
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        this.mapReplicationStateHolder.writeData(out);
        this.writeBehindStateHolder.writeData(out);
        this.mapNearCacheStateHolder.writeData(out);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.mapReplicationStateHolder.readData(in);
        this.writeBehindStateHolder.readData(in);
        this.mapNearCacheStateHolder.readData(in);
    }

    RecordReplicationInfo toReplicationInfo(Record record, SerializationService ss) {
        RecordInfo info = Records.buildRecordInfo(record);
        Object dataValue = ss.toData(record.getValue());
        return new RecordReplicationInfo(record.getKey(), (Data)dataValue, info);
    }

    RecordStore getRecordStore(String mapName) {
        boolean skipLoadingOnRecordStoreCreate = true;
        MapService mapService = (MapService)this.getService();
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        return mapServiceContext.getRecordStore(this.getPartitionId(), mapName, true);
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 96;
    }
}

