/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.map.impl.query;

import com.atlassian.nutcluster.map.impl.query.PartitionScanExecutor;
import com.atlassian.nutcluster.map.impl.query.PartitionScanRunner;
import com.atlassian.nutcluster.map.impl.query.Result;
import com.atlassian.nutcluster.query.Predicate;
import com.atlassian.nutcluster.query.impl.QueryableEntriesSegment;
import com.atlassian.nutcluster.spi.exception.RetryableNutclusterException;
import java.util.Collection;

public class CallerRunsPartitionScanExecutor
implements PartitionScanExecutor {
    private final PartitionScanRunner partitionScanRunner;

    public CallerRunsPartitionScanExecutor(PartitionScanRunner partitionScanRunner) {
        this.partitionScanRunner = partitionScanRunner;
    }

    @Override
    public void execute(String mapName, Predicate predicate, Collection<Integer> partitions, Result result) {
        RetryableNutclusterException storedException = null;
        for (Integer partitionId : partitions) {
            try {
                this.partitionScanRunner.run(mapName, predicate, partitionId, result);
            }
            catch (RetryableNutclusterException e) {
                if (storedException != null) continue;
                storedException = e;
            }
        }
        if (storedException != null) {
            throw storedException;
        }
    }

    @Override
    public QueryableEntriesSegment execute(String mapName, Predicate predicate, int partitionId, int tableIndex, int fetchSize) {
        return this.partitionScanRunner.run(mapName, predicate, partitionId, tableIndex, fetchSize);
    }
}

