/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.map.impl.query;

import com.atlassian.nutcluster.map.impl.query.QueryResult;
import com.atlassian.nutcluster.map.impl.query.QueryResultCollection;
import com.atlassian.nutcluster.query.PagingPredicate;
import com.atlassian.nutcluster.query.PartitionPredicate;
import com.atlassian.nutcluster.query.Predicate;
import com.atlassian.nutcluster.spi.serialization.SerializationService;
import com.atlassian.nutcluster.util.IterationType;
import com.atlassian.nutcluster.util.SortingUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public final class QueryResultUtils {
    private QueryResultUtils() {
    }

    public static Set transformToSet(SerializationService ss, QueryResult queryResult, Predicate predicate, IterationType iterationType, boolean unique, boolean binary) {
        Predicate unwrappedPredicate = QueryResultUtils.unwrapPartitionPredicate(predicate);
        if (unwrappedPredicate instanceof PagingPredicate) {
            QueryResultCollection result = new QueryResultCollection(ss, IterationType.ENTRY, binary, unique, queryResult);
            return SortingUtil.getSortedQueryResultSet(new ArrayList<Map.Entry>(result), (PagingPredicate)unwrappedPredicate, iterationType);
        }
        return new QueryResultCollection(ss, iterationType, binary, unique, queryResult);
    }

    private static Predicate unwrapPartitionPredicate(Predicate predicate) {
        return predicate instanceof PartitionPredicate ? ((PartitionPredicate)predicate).getTarget() : predicate;
    }
}

