/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.map.impl.querycache.subscriber.operation;

import com.atlassian.nutcluster.logging.ILogger;
import com.atlassian.nutcluster.logging.Logger;
import com.atlassian.nutcluster.map.impl.MapDataSerializerHook;
import com.atlassian.nutcluster.map.impl.MapService;
import com.atlassian.nutcluster.map.impl.MapServiceContext;
import com.atlassian.nutcluster.map.impl.operation.MapOperation;
import com.atlassian.nutcluster.map.impl.querycache.QueryCacheContext;
import com.atlassian.nutcluster.map.impl.querycache.accumulator.AccumulatorInfo;
import com.atlassian.nutcluster.map.impl.querycache.publisher.PartitionAccumulatorRegistry;
import com.atlassian.nutcluster.map.impl.querycache.utils.QueryCacheUtil;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import java.io.IOException;

public class MadePublishableOperation
extends MapOperation {
    private final ILogger logger = Logger.getLogger(this.getClass());
    private String cacheId;
    private transient boolean done;

    public MadePublishableOperation() {
    }

    public MadePublishableOperation(String mapName, String cacheId) {
        super(mapName);
        this.cacheId = cacheId;
    }

    @Override
    public void run() throws Exception {
        this.setPublishable();
    }

    private void setPublishable() {
        PartitionAccumulatorRegistry registry = QueryCacheUtil.getAccumulatorRegistryOrNull(this.getContext(), this.name, this.cacheId);
        if (registry == null) {
            return;
        }
        AccumulatorInfo info = registry.getInfo();
        info.setPublishable(true);
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Accumulator was made publishable for map=" + this.getName());
        }
        this.done = true;
    }

    private QueryCacheContext getContext() {
        MapService service = (MapService)this.getService();
        MapServiceContext mapServiceContext = service.getMapServiceContext();
        return mapServiceContext.getQueryCacheContext();
    }

    @Override
    public Object getResponse() {
        return this.done;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.cacheId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.cacheId = in.readUTF();
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 124;
    }
}

