/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.map.impl.querycache.subscriber.operation;

import com.atlassian.nutcluster.map.impl.MapDataSerializerHook;
import com.atlassian.nutcluster.map.impl.querycache.subscriber.operation.MadePublishableOperation;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.spi.OperationFactory;
import com.atlassian.nutcluster.util.Preconditions;
import java.io.IOException;

public class MadePublishableOperationFactory
implements OperationFactory {
    private String mapName;
    private String cacheId;

    public MadePublishableOperationFactory() {
    }

    public MadePublishableOperationFactory(String mapName, String cacheId) {
        Preconditions.checkHasText(mapName, "mapName");
        Preconditions.checkHasText(cacheId, "cacheId");
        this.cacheId = cacheId;
        this.mapName = mapName;
    }

    @Override
    public Operation createOperation() {
        return new MadePublishableOperation(this.mapName, this.cacheId);
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.mapName);
        out.writeUTF(this.cacheId);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.mapName = in.readUTF();
        this.cacheId = in.readUTF();
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 125;
    }
}

