/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.mapreduce.aggregation.impl;

import com.atlassian.nutcluster.mapreduce.Collator;
import com.atlassian.nutcluster.mapreduce.Combiner;
import com.atlassian.nutcluster.mapreduce.CombinerFactory;
import com.atlassian.nutcluster.mapreduce.Mapper;
import com.atlassian.nutcluster.mapreduce.Reducer;
import com.atlassian.nutcluster.mapreduce.ReducerFactory;
import com.atlassian.nutcluster.mapreduce.aggregation.Supplier;
import com.atlassian.nutcluster.mapreduce.aggregation.impl.AbstractAggregationCombinerFactory;
import com.atlassian.nutcluster.mapreduce.aggregation.impl.AbstractAggregationReducerFactory;
import com.atlassian.nutcluster.mapreduce.aggregation.impl.AggType;
import com.atlassian.nutcluster.mapreduce.aggregation.impl.SupplierConsumingMapper;
import com.atlassian.nutcluster.nio.serialization.BinaryInterface;
import java.math.BigDecimal;
import java.util.Map;

public class BigDecimalMaxAggregation<Key, Value>
implements AggType<Key, Value, Key, BigDecimal, BigDecimal, BigDecimal, BigDecimal> {
    @Override
    public Collator<Map.Entry<Key, BigDecimal>, BigDecimal> getCollator() {
        return new Collator<Map.Entry<Key, BigDecimal>, BigDecimal>(this){

            @Override
            public BigDecimal collate(Iterable<Map.Entry<Key, BigDecimal>> values) {
                BigDecimal max = null;
                for (Map.Entry entry : values) {
                    BigDecimal value = entry.getValue();
                    max = max == null ? value : value.max(max);
                }
                return max;
            }
        };
    }

    @Override
    public Mapper<Key, Value, Key, BigDecimal> getMapper(Supplier<Key, Value, BigDecimal> supplier) {
        return new SupplierConsumingMapper<Key, Value, BigDecimal>(supplier);
    }

    @Override
    public CombinerFactory<Key, BigDecimal, BigDecimal> getCombinerFactory() {
        return new BigDecimalMaxCombinerFactory();
    }

    @Override
    public ReducerFactory<Key, BigDecimal, BigDecimal> getReducerFactory() {
        return new BigDecimalMaxReducerFactory();
    }

    @BinaryInterface
    static final class BigDecimalMaxCombinerFactory<Key>
    extends AbstractAggregationCombinerFactory<Key, BigDecimal, BigDecimal> {
        BigDecimalMaxCombinerFactory() {
        }

        @Override
        public Combiner<BigDecimal, BigDecimal> newCombiner(Key key) {
            return new BigDecimalMaxCombiner();
        }

        @Override
        public int getId() {
            return 6;
        }
    }

    @BinaryInterface
    static final class BigDecimalMaxReducerFactory<Key>
    extends AbstractAggregationReducerFactory<Key, BigDecimal, BigDecimal> {
        BigDecimalMaxReducerFactory() {
        }

        @Override
        public Reducer<BigDecimal, BigDecimal> newReducer(Key key) {
            return new BigDecimalMaxReducer();
        }

        @Override
        public int getId() {
            return 7;
        }
    }

    private static final class BigDecimalMaxReducer
    extends Reducer<BigDecimal, BigDecimal> {
        private BigDecimal max;

        private BigDecimalMaxReducer() {
        }

        @Override
        public void reduce(BigDecimal value) {
            this.max = this.max == null ? value : value.max(this.max);
        }

        @Override
        public BigDecimal finalizeReduce() {
            return this.max;
        }
    }

    private static final class BigDecimalMaxCombiner
    extends Combiner<BigDecimal, BigDecimal> {
        private BigDecimal max;

        private BigDecimalMaxCombiner() {
        }

        @Override
        public void combine(BigDecimal value) {
            this.max = this.max == null ? value : value.max(this.max);
        }

        @Override
        public BigDecimal finalizeChunk() {
            return this.max;
        }

        @Override
        public void reset() {
            this.max = null;
        }
    }
}

