/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.mapreduce.aggregation.impl;

import com.atlassian.nutcluster.mapreduce.Collator;
import com.atlassian.nutcluster.mapreduce.Combiner;
import com.atlassian.nutcluster.mapreduce.CombinerFactory;
import com.atlassian.nutcluster.mapreduce.Mapper;
import com.atlassian.nutcluster.mapreduce.Reducer;
import com.atlassian.nutcluster.mapreduce.ReducerFactory;
import com.atlassian.nutcluster.mapreduce.aggregation.Supplier;
import com.atlassian.nutcluster.mapreduce.aggregation.impl.AbstractAggregationCombinerFactory;
import com.atlassian.nutcluster.mapreduce.aggregation.impl.AbstractAggregationReducerFactory;
import com.atlassian.nutcluster.mapreduce.aggregation.impl.AggType;
import com.atlassian.nutcluster.mapreduce.aggregation.impl.SupplierConsumingMapper;
import com.atlassian.nutcluster.nio.serialization.BinaryInterface;
import java.util.Map;

public class LongSumAggregation<Key, Value>
implements AggType<Key, Value, Key, Long, Long, Long, Long> {
    @Override
    public Collator<Map.Entry<Key, Long>, Long> getCollator() {
        return new Collator<Map.Entry<Key, Long>, Long>(this){

            @Override
            public Long collate(Iterable<Map.Entry<Key, Long>> values) {
                long sum = 0L;
                for (Map.Entry entry : values) {
                    sum += entry.getValue().longValue();
                }
                return sum;
            }
        };
    }

    @Override
    public Mapper<Key, Value, Key, Long> getMapper(Supplier<Key, Value, Long> supplier) {
        return new SupplierConsumingMapper<Key, Value, Long>(supplier);
    }

    @Override
    public CombinerFactory<Key, Long, Long> getCombinerFactory() {
        return new LongSumCombinerFactory();
    }

    @Override
    public ReducerFactory<Key, Long, Long> getReducerFactory() {
        return new LongSumReducerFactory();
    }

    @BinaryInterface
    static final class LongSumCombinerFactory<Key>
    extends AbstractAggregationCombinerFactory<Key, Long, Long> {
        LongSumCombinerFactory() {
        }

        @Override
        public Combiner<Long, Long> newCombiner(Key key) {
            return new LongSumCombiner();
        }

        @Override
        public int getId() {
            return 50;
        }
    }

    @BinaryInterface
    static final class LongSumReducerFactory<Key>
    extends AbstractAggregationReducerFactory<Key, Long, Long> {
        LongSumReducerFactory() {
        }

        @Override
        public Reducer<Long, Long> newReducer(Key key) {
            return new LongSumReducer();
        }

        @Override
        public int getId() {
            return 51;
        }
    }

    private static final class LongSumReducer
    extends Reducer<Long, Long> {
        private long sum;

        private LongSumReducer() {
        }

        @Override
        public void reduce(Long value) {
            this.sum += value.longValue();
        }

        @Override
        public Long finalizeReduce() {
            return this.sum;
        }
    }

    private static final class LongSumCombiner
    extends Combiner<Long, Long> {
        private long chunkSum;

        private LongSumCombiner() {
        }

        @Override
        public void combine(Long value) {
            this.chunkSum += value.longValue();
        }

        @Override
        public Long finalizeChunk() {
            long value = this.chunkSum;
            this.chunkSum = 0L;
            return value;
        }
    }
}

