/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.mapreduce.impl.operation;

import com.atlassian.nutcluster.mapreduce.impl.MapReduceDataSerializerHook;
import com.atlassian.nutcluster.mapreduce.impl.MapReduceService;
import com.atlassian.nutcluster.mapreduce.impl.operation.ProcessingOperation;
import com.atlassian.nutcluster.mapreduce.impl.task.JobProcessInformationImpl;
import com.atlassian.nutcluster.mapreduce.impl.task.JobSupervisor;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import java.io.IOException;

public class ProcessStatsUpdateOperation
extends ProcessingOperation {
    private int processedRecords;

    public ProcessStatsUpdateOperation() {
    }

    public ProcessStatsUpdateOperation(String name, String jobId, int processedRecords) {
        super(name, jobId);
        this.processedRecords = processedRecords;
    }

    @Override
    public void run() throws Exception {
        MapReduceService mapReduceService = (MapReduceService)this.getService();
        JobSupervisor supervisor = mapReduceService.getJobSupervisor(this.getName(), this.getJobId());
        if (supervisor != null) {
            JobProcessInformationImpl processInformation = supervisor.getJobProcessInformation();
            processInformation.addProcessedRecords(this.processedRecords);
        }
    }

    @Override
    public Object getResponse() {
        return Boolean.TRUE;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.processedRecords);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.processedRecords = in.readInt();
    }

    @Override
    public int getFactoryId() {
        return MapReduceDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 14;
    }
}

