/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.multimap.impl;

import com.atlassian.nutcluster.core.EntryEvent;
import com.atlassian.nutcluster.core.EntryListener;
import com.atlassian.nutcluster.core.IMapEvent;
import com.atlassian.nutcluster.core.MapEvent;
import com.atlassian.nutcluster.core.Member;
import com.atlassian.nutcluster.instance.MemberImpl;
import com.atlassian.nutcluster.internal.cluster.ClusterService;
import com.atlassian.nutcluster.logging.ILogger;
import com.atlassian.nutcluster.logging.Logger;
import com.atlassian.nutcluster.map.impl.DataAwareEntryEvent;
import com.atlassian.nutcluster.map.impl.event.EntryEventData;
import com.atlassian.nutcluster.map.impl.event.EventData;
import com.atlassian.nutcluster.map.impl.event.MapEventData;
import com.atlassian.nutcluster.multimap.impl.MultiMapService;

class MultiMapEventsDispatcher {
    private final ILogger logger = Logger.getLogger(MultiMapEventsDispatcher.class);
    private final ClusterService clusterService;
    private final MultiMapService multiMapService;

    MultiMapEventsDispatcher(MultiMapService multiMapService, ClusterService clusterService) {
        this.multiMapService = multiMapService;
        this.clusterService = clusterService;
    }

    private void incrementEventStats(IMapEvent event) {
        this.multiMapService.getLocalMultiMapStatsImpl(event.getName()).incrementReceivedEvents();
    }

    public void dispatchEvent(EventData eventData, EntryListener listener) {
        if (eventData instanceof EntryEventData) {
            this.dispatchEntryEventData(eventData, listener);
        } else if (eventData instanceof MapEventData) {
            this.dispatchMapEventData(eventData, listener);
        } else {
            throw new IllegalArgumentException("Unknown multimap event data");
        }
    }

    private void dispatchMapEventData(EventData eventData, EntryListener listener) {
        MapEventData mapEventData = (MapEventData)eventData;
        Member member = this.getMemberOrNull(eventData);
        if (member == null) {
            return;
        }
        MapEvent event = this.createMapEvent(mapEventData, member);
        this.dispatch0(event, listener);
        this.incrementEventStats(event);
    }

    private MapEvent createMapEvent(MapEventData mapEventData, Member member) {
        return new MapEvent(mapEventData.getMapName(), member, mapEventData.getEventType(), mapEventData.getNumberOfEntries());
    }

    private void dispatchEntryEventData(EventData eventData, EntryListener listener) {
        EntryEventData entryEventData = (EntryEventData)eventData;
        Member member = this.getMemberOrNull(eventData);
        DataAwareEntryEvent event = this.createDataAwareEntryEvent(entryEventData, member);
        this.dispatch0(event, listener);
        this.incrementEventStats(event);
    }

    private Member getMemberOrNull(EventData eventData) {
        MemberImpl member = this.clusterService.getMember(eventData.getCaller());
        if (member == null && this.logger.isInfoEnabled()) {
            this.logger.info("Dropping event " + String.valueOf(eventData) + " from unknown address:" + String.valueOf(eventData.getCaller()));
        }
        return member;
    }

    private DataAwareEntryEvent createDataAwareEntryEvent(EntryEventData entryEventData, Member member) {
        return new DataAwareEntryEvent(member, entryEventData.getEventType(), entryEventData.getMapName(), entryEventData.getDataKey(), entryEventData.getDataNewValue(), entryEventData.getDataOldValue(), entryEventData.getDataMergingValue(), this.multiMapService.getSerializationService());
    }

    private void dispatch0(IMapEvent event, EntryListener listener) {
        switch (event.getEventType()) {
            case ADDED: {
                listener.entryAdded((EntryEvent)event);
                break;
            }
            case REMOVED: {
                listener.entryRemoved((EntryEvent)event);
                break;
            }
            case CLEAR_ALL: {
                listener.mapCleared((MapEvent)event);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid event type: " + String.valueOf((Object)event.getEventType()));
            }
        }
    }
}

