/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.multimap.impl.operations;

import com.atlassian.nutcluster.config.MultiMapConfig;
import com.atlassian.nutcluster.core.EntryEventType;
import com.atlassian.nutcluster.multimap.impl.MultiMapContainer;
import com.atlassian.nutcluster.multimap.impl.MultiMapRecord;
import com.atlassian.nutcluster.multimap.impl.operations.AbstractBackupAwareMultiMapOperation;
import com.atlassian.nutcluster.multimap.impl.operations.MultiMapResponse;
import com.atlassian.nutcluster.multimap.impl.operations.RemoveAllBackupOperation;
import com.atlassian.nutcluster.nio.serialization.Data;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.spi.impl.MutatingOperation;
import java.util.Collection;

public class RemoveAllOperation
extends AbstractBackupAwareMultiMapOperation
implements MutatingOperation {
    private Collection<MultiMapRecord> coll;

    public RemoveAllOperation() {
    }

    public RemoveAllOperation(String name, Data dataKey, long threadId) {
        super(name, dataKey, threadId);
    }

    @Override
    public void run() throws Exception {
        MultiMapContainer container = this.getOrCreateContainer();
        this.coll = container.remove(this.dataKey, this.executedLocally());
        this.response = new MultiMapResponse(this.coll, this.getValueCollectionType(container));
    }

    @Override
    public void afterRun() throws Exception {
        if (this.coll != null) {
            this.getOrCreateContainer().update();
            for (MultiMapRecord record : this.coll) {
                this.publishEvent(EntryEventType.REMOVED, this.dataKey, null, record.getObject());
            }
        }
    }

    @Override
    public boolean shouldBackup() {
        return this.coll != null;
    }

    @Override
    public Operation getBackupOperation() {
        return new RemoveAllBackupOperation(this.name, this.dataKey);
    }

    @Override
    public void onWaitExpire() {
        MultiMapContainer container = this.getOrCreateContainer();
        MultiMapConfig.ValueCollectionType valueCollectionType = this.getValueCollectionType(container);
        this.sendResponse(new MultiMapResponse(null, valueCollectionType));
    }

    @Override
    public int getId() {
        return 18;
    }
}

