/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.nio.ascii;

import com.atlassian.nutcluster.internal.ascii.CommandParser;
import com.atlassian.nutcluster.internal.ascii.rest.HttpDeleteCommandParser;
import com.atlassian.nutcluster.internal.ascii.rest.HttpGetCommandParser;
import com.atlassian.nutcluster.internal.ascii.rest.HttpHeadCommandParser;
import com.atlassian.nutcluster.internal.ascii.rest.HttpPostCommandParser;
import com.atlassian.nutcluster.nio.IOService;
import com.atlassian.nutcluster.nio.ascii.RestApiFilter;
import com.atlassian.nutcluster.nio.ascii.TextDecoder;
import com.atlassian.nutcluster.nio.ascii.TextEncoder;
import com.atlassian.nutcluster.nio.ascii.TextParsers;
import com.atlassian.nutcluster.nio.tcp.TcpIpConnection;
import com.atlassian.nutcluster.spi.annotation.PrivateApi;
import java.util.HashMap;

@PrivateApi
public class RestApiTextDecoder
extends TextDecoder {
    public static final TextParsers TEXT_PARSERS;

    public RestApiTextDecoder(TcpIpConnection connection, TextEncoder encoder, boolean rootDecoder) {
        super(connection, encoder, RestApiTextDecoder.createFilter(connection), TEXT_PARSERS, rootDecoder);
    }

    private static RestApiFilter createFilter(TcpIpConnection connection) {
        IOService ioService = connection.getEndpointManager().getNetworkingService().getIoService();
        return new RestApiFilter(ioService.getRestApiConfig(), TEXT_PARSERS);
    }

    static {
        HashMap<String, CommandParser> parsers = new HashMap<String, CommandParser>();
        parsers.put("GET", new HttpGetCommandParser());
        parsers.put("POST", new HttpPostCommandParser());
        parsers.put("PUT", new HttpPostCommandParser());
        parsers.put("DELETE", new HttpDeleteCommandParser());
        parsers.put("HEAD", new HttpHeadCommandParser());
        TEXT_PARSERS = new TextParsers(parsers);
    }
}

