/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.nio.tcp;

import com.atlassian.nutcluster.internal.networking.HandlerStatus;
import com.atlassian.nutcluster.internal.networking.OutboundHandler;
import com.atlassian.nutcluster.nio.ConnectionType;
import com.atlassian.nutcluster.nio.IOUtil;
import com.atlassian.nutcluster.nio.tcp.TcpIpConnection;
import com.atlassian.nutcluster.util.StringUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.ByteBuffer;

public class MemberProtocolEncoder
extends OutboundHandler<Void, ByteBuffer> {
    private final OutboundHandler[] outboundHandlers;
    private volatile boolean mustWriteProtocol;
    private boolean clusterProtocolBuffered;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public MemberProtocolEncoder(OutboundHandler[] next) {
        this.outboundHandlers = next;
    }

    @Override
    public void handlerAdded() {
        this.initDstBuffer(3);
        if (this.channel.isClientMode()) {
            this.mustWriteProtocol = true;
        }
    }

    @Override
    public HandlerStatus onWrite() {
        IOUtil.compactOrClear((ByteBuffer)this.dst);
        try {
            if (!this.mustWriteProtocol) {
                HandlerStatus handlerStatus = HandlerStatus.CLEAN;
                return handlerStatus;
            }
            if (!this.clusterProtocolBuffered) {
                this.clusterProtocolBuffered = true;
                ((ByteBuffer)this.dst).put(StringUtil.stringToBytes("HZC"));
                HandlerStatus handlerStatus = HandlerStatus.DIRTY;
                return handlerStatus;
            }
            if (!this.isProtocolBufferDrained()) {
                HandlerStatus handlerStatus = HandlerStatus.DIRTY;
                return handlerStatus;
            }
            TcpIpConnection connection = (TcpIpConnection)this.channel.attributeMap().get(TcpIpConnection.class);
            connection.setType(ConnectionType.MEMBER);
            this.channel.outboundPipeline().replace(this, this.outboundHandlers);
            HandlerStatus handlerStatus = HandlerStatus.CLEAN;
            return handlerStatus;
        }
        finally {
            ((ByteBuffer)this.dst).flip();
        }
    }

    public void signalProtocolLoaded() {
        assert (!this.channel.isClientMode()) : "Signal protocol should only be made on channel in serverMode";
        this.mustWriteProtocol = true;
        this.channel.outboundPipeline().wakeup();
    }

    private boolean isProtocolBufferDrained() {
        return ((ByteBuffer)this.dst).position() == 0;
    }
}

