/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.nio.tcp;

import com.atlassian.nutcluster.instance.OutOfMemoryErrorDispatcher;
import com.atlassian.nutcluster.internal.networking.Channel;
import com.atlassian.nutcluster.internal.networking.ChannelErrorHandler;
import com.atlassian.nutcluster.logging.ILogger;
import com.atlassian.nutcluster.nio.tcp.TcpIpConnection;
import java.io.EOFException;

public class TcpIpConnectionChannelErrorHandler
implements ChannelErrorHandler {
    private final ILogger logger;

    public TcpIpConnectionChannelErrorHandler(ILogger logger) {
        this.logger = logger;
    }

    @Override
    public void onError(Channel channel, Throwable error) {
        if (error instanceof OutOfMemoryError) {
            OutOfMemoryErrorDispatcher.onOutOfMemory((OutOfMemoryError)error);
        }
        if (channel == null) {
            this.logger.severe(error);
        } else {
            TcpIpConnection connection = (TcpIpConnection)channel.attributeMap().get(TcpIpConnection.class);
            if (connection != null) {
                String closeReason = error instanceof EOFException ? "Connection closed by the other side" : "Exception in " + String.valueOf(connection) + ", thread=" + Thread.currentThread().getName();
                connection.close(closeReason, error);
            } else {
                this.logger.warning("Channel error occured", error);
            }
        }
    }
}

