/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.osgi.impl;

import com.atlassian.nutcluster.logging.ILogger;
import com.atlassian.nutcluster.logging.Logger;
import com.atlassian.nutcluster.osgi.impl.NutclusterInternalOSGiService;
import com.atlassian.nutcluster.osgi.impl.NutclusterOSGiServiceImpl;
import java.lang.reflect.Method;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private static final ILogger LOGGER = Logger.getLogger(Activator.class);
    private volatile NutclusterInternalOSGiService hazelcastOSGiService;

    public void start(BundleContext context) throws Exception {
        this.activateJavaxScripting(context);
        assert (this.hazelcastOSGiService == null) : "Nutcluster OSGI service should be null while starting!";
        this.hazelcastOSGiService = new NutclusterOSGiServiceImpl(context.getBundle());
        this.hazelcastOSGiService.activate();
    }

    public void stop(BundleContext context) throws Exception {
        assert (this.hazelcastOSGiService != null) : "Nutcluster OSGI service should not be null while stopping!";
        this.hazelcastOSGiService.deactivate();
        this.hazelcastOSGiService = null;
    }

    private void activateJavaxScripting(BundleContext context) throws Exception {
        if (Activator.isJavaxScriptingAvailable()) {
            Class clazz = context.getBundle().loadClass("com.atlassian.nutcluster.osgi.impl.ScriptEngineActivator");
            Method register = clazz.getDeclaredMethod("registerOsgiScriptEngineManager", BundleContext.class);
            register.setAccessible(true);
            register.invoke((Object)clazz, context);
        } else {
            LOGGER.warning("javax.scripting is not available, scripts from Management Center cannot be executed!");
        }
    }

    static boolean isJavaxScriptingAvailable() {
        if (Boolean.getBoolean("hazelcast.osgi.jsr223.disabled")) {
            return false;
        }
        try {
            Class.forName("javax.script.ScriptEngineManager");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

