/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.partition.membergroup;

import com.atlassian.nutcluster.core.Member;
import com.atlassian.nutcluster.instance.MemberImpl;
import com.atlassian.nutcluster.nio.Address;
import com.atlassian.nutcluster.partition.membergroup.BackupSafeMemberGroupFactory;
import com.atlassian.nutcluster.partition.membergroup.DefaultMemberGroup;
import com.atlassian.nutcluster.partition.membergroup.MemberGroup;
import com.atlassian.nutcluster.partition.membergroup.MemberGroupFactory;
import com.atlassian.nutcluster.util.MapUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class HostAwareMemberGroupFactory
extends BackupSafeMemberGroupFactory
implements MemberGroupFactory {
    @Override
    protected Set<MemberGroup> createInternalMemberGroups(Collection<? extends Member> allMembers) {
        Map<String, MemberGroup> groups = MapUtil.createHashMap(allMembers.size());
        for (Member member : allMembers) {
            Address address = ((MemberImpl)member).getAddress();
            MemberGroup group = (MemberGroup)groups.get(address.getHost());
            if (group == null) {
                group = new DefaultMemberGroup();
                groups.put(address.getHost(), group);
            }
            group.addMember(member);
        }
        return new HashSet<MemberGroup>(groups.values());
    }
}

