/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.partition.membergroup;

import com.atlassian.nutcluster.config.PartitionGroupConfig;
import com.atlassian.nutcluster.partition.membergroup.ConfigMemberGroupFactory;
import com.atlassian.nutcluster.partition.membergroup.HostAwareMemberGroupFactory;
import com.atlassian.nutcluster.partition.membergroup.MemberGroupFactory;
import com.atlassian.nutcluster.partition.membergroup.NodeAwareMemberGroupFactory;
import com.atlassian.nutcluster.partition.membergroup.SPIAwareMemberGroupFactory;
import com.atlassian.nutcluster.partition.membergroup.SingleMemberGroupFactory;
import com.atlassian.nutcluster.partition.membergroup.ZoneAwareMemberGroupFactory;
import com.atlassian.nutcluster.spi.discovery.integration.DiscoveryService;

public final class MemberGroupFactoryFactory {
    private MemberGroupFactoryFactory() {
    }

    public static MemberGroupFactory newMemberGroupFactory(PartitionGroupConfig partitionGroupConfig, DiscoveryService discoveryService) {
        PartitionGroupConfig.MemberGroupType memberGroupType = partitionGroupConfig == null || !partitionGroupConfig.isEnabled() ? PartitionGroupConfig.MemberGroupType.PER_MEMBER : partitionGroupConfig.getGroupType();
        switch (memberGroupType) {
            case HOST_AWARE: {
                return new HostAwareMemberGroupFactory();
            }
            case CUSTOM: {
                return new ConfigMemberGroupFactory(partitionGroupConfig.getMemberGroupConfigs());
            }
            case PER_MEMBER: {
                return new SingleMemberGroupFactory();
            }
            case ZONE_AWARE: {
                return new ZoneAwareMemberGroupFactory();
            }
            case NODE_AWARE: {
                return new NodeAwareMemberGroupFactory();
            }
            case SPI: {
                return new SPIAwareMemberGroupFactory(discoveryService);
            }
        }
        throw new RuntimeException("Unknown MemberGroupType:" + String.valueOf((Object)memberGroupType));
    }
}

