/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.query.impl;

import com.atlassian.nutcluster.internal.serialization.InternalSerializationService;
import com.atlassian.nutcluster.monitor.impl.PerIndexStats;
import com.atlassian.nutcluster.query.impl.AbstractIndex;
import com.atlassian.nutcluster.query.impl.BitmapIndexStore;
import com.atlassian.nutcluster.query.impl.IndexCopyBehavior;
import com.atlassian.nutcluster.query.impl.IndexDefinition;
import com.atlassian.nutcluster.query.impl.IndexStore;
import com.atlassian.nutcluster.query.impl.OrderedIndexStore;
import com.atlassian.nutcluster.query.impl.UnorderedIndexStore;
import com.atlassian.nutcluster.query.impl.getters.Extractors;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class IndexImpl
extends AbstractIndex {
    private final Set<Integer> indexedPartitions = Collections.newSetFromMap(new ConcurrentHashMap());

    public IndexImpl(IndexDefinition definition, InternalSerializationService ss, Extractors extractors, IndexCopyBehavior copyBehavior, PerIndexStats stats) {
        super(definition, ss, extractors, copyBehavior, stats);
    }

    @Override
    protected IndexStore createIndexStore(IndexDefinition definition, PerIndexStats stats) {
        if (definition.getUniqueKey() == null) {
            return definition.isOrdered() ? new OrderedIndexStore(this.copyBehavior) : new UnorderedIndexStore(this.copyBehavior);
        }
        return new BitmapIndexStore(definition, this.ss, this.extractors);
    }

    @Override
    public void clear() {
        super.clear();
        this.indexedPartitions.clear();
    }

    @Override
    public boolean hasPartitionIndexed(int partitionId) {
        return this.indexedPartitions.contains(partitionId);
    }

    @Override
    public boolean allPartitionsIndexed(int ownedPartitionCount) {
        return ownedPartitionCount < 0 || this.indexedPartitions.size() == ownedPartitionCount;
    }

    @Override
    public void markPartitionAsIndexed(int partitionId) {
        assert (!this.indexedPartitions.contains(partitionId));
        this.indexedPartitions.add(partitionId);
    }

    @Override
    public void markPartitionAsUnindexed(int partitionId) {
        this.indexedPartitions.remove(partitionId);
    }
}

