/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.quorum.impl;

import com.atlassian.nutcluster.config.Config;
import com.atlassian.nutcluster.config.ConfigAccessor;
import com.atlassian.nutcluster.config.IcmpFailureDetectorConfig;
import com.atlassian.nutcluster.core.Member;
import com.atlassian.nutcluster.core.MemberAttributeEvent;
import com.atlassian.nutcluster.core.MembershipEvent;
import com.atlassian.nutcluster.core.MembershipListener;
import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.core.NutclusterInstanceAware;
import com.atlassian.nutcluster.internal.cluster.fd.PingFailureDetector;
import com.atlassian.nutcluster.quorum.PingAware;
import com.atlassian.nutcluster.spi.properties.GroupProperty;
import com.atlassian.nutcluster.spi.properties.NutclusterProperties;

public abstract class AbstractPingAwareQuorumFunction
implements PingAware,
NutclusterInstanceAware,
MembershipListener {
    private boolean pingFDEnabled;
    private PingFailureDetector<Member> pingFailureDetector;

    @Override
    public void setNutclusterInstance(NutclusterInstance NutclusterInstance2) {
        boolean icmpParallelMode;
        boolean icmpEnabled;
        Config config = NutclusterInstance2.getConfig();
        IcmpFailureDetectorConfig icmpFailureDetectorConfig = ConfigAccessor.getActiveMemberNetworkConfig(config).getIcmpFailureDetectorConfig();
        NutclusterProperties nutclusterProperties = new NutclusterProperties(config);
        boolean bl = icmpEnabled = icmpFailureDetectorConfig == null ? nutclusterProperties.getBoolean(GroupProperty.ICMP_ENABLED) : icmpFailureDetectorConfig.isEnabled();
        boolean bl2 = icmpEnabled && (icmpFailureDetectorConfig == null ? nutclusterProperties.getBoolean(GroupProperty.ICMP_PARALLEL_MODE) : icmpFailureDetectorConfig.isParallelMode()) ? true : (icmpParallelMode = false);
        if (!icmpEnabled || !icmpParallelMode) {
            return;
        }
        int icmpMaxAttempts = icmpFailureDetectorConfig == null ? nutclusterProperties.getInteger(GroupProperty.ICMP_MAX_ATTEMPTS) : icmpFailureDetectorConfig.getMaxAttempts();
        this.pingFailureDetector = new PingFailureDetector(icmpMaxAttempts);
        this.pingFDEnabled = true;
    }

    @Override
    public void onPingLost(Member member) {
        if (!this.pingFDEnabled) {
            return;
        }
        this.pingFailureDetector.logAttempt(member);
    }

    @Override
    public void onPingRestored(Member member) {
        if (!this.pingFDEnabled) {
            return;
        }
        this.pingFailureDetector.heartbeat(member);
    }

    @Override
    public void memberAdded(MembershipEvent membershipEvent) {
        if (this.pingFDEnabled) {
            this.pingFailureDetector.heartbeat(membershipEvent.getMember());
        }
    }

    @Override
    public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
    }

    @Override
    public void memberRemoved(MembershipEvent membershipEvent) {
        if (this.pingFDEnabled) {
            this.pingFailureDetector.remove(membershipEvent.getMember());
        }
    }

    protected boolean isAlivePerIcmp(Member member) {
        if (!this.pingFDEnabled || member.localMember()) {
            return true;
        }
        return this.pingFailureDetector.isAlive(member);
    }
}

