/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.replicatedmap.impl;

import com.atlassian.nutcluster.config.InMemoryFormat;
import com.atlassian.nutcluster.config.MergePolicyConfig;
import com.atlassian.nutcluster.config.ReplicatedMapConfig;
import com.atlassian.nutcluster.replicatedmap.impl.ReplicatedMapService;
import com.atlassian.nutcluster.replicatedmap.impl.ReplicatedMapSplitBrainHandlerService;
import com.atlassian.nutcluster.replicatedmap.impl.operation.LegacyMergeOperation;
import com.atlassian.nutcluster.replicatedmap.impl.operation.MergeOperationFactory;
import com.atlassian.nutcluster.replicatedmap.impl.record.ReplicatedMapEntryView;
import com.atlassian.nutcluster.replicatedmap.impl.record.ReplicatedRecord;
import com.atlassian.nutcluster.replicatedmap.impl.record.ReplicatedRecordStore;
import com.atlassian.nutcluster.replicatedmap.merge.ReplicatedMapMergePolicy;
import com.atlassian.nutcluster.spi.NodeEngine;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.spi.OperationFactory;
import com.atlassian.nutcluster.spi.impl.merge.AbstractMergeRunnable;
import com.atlassian.nutcluster.spi.impl.merge.MergingValueFactory;
import com.atlassian.nutcluster.spi.merge.SplitBrainMergePolicy;
import com.atlassian.nutcluster.spi.merge.SplitBrainMergeTypes;
import com.atlassian.nutcluster.spi.serialization.SerializationService;
import com.atlassian.nutcluster.util.function.BiConsumer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

class ReplicatedMapMergeRunnable
extends AbstractMergeRunnable<Object, Object, ReplicatedRecordStore, SplitBrainMergeTypes.ReplicatedMapMergeTypes> {
    private final ReplicatedMapService service;

    ReplicatedMapMergeRunnable(Collection<ReplicatedRecordStore> mergingStores, ReplicatedMapSplitBrainHandlerService splitBrainHandlerService, NodeEngine nodeEngine) {
        super("hz:impl:replicatedMapService", mergingStores, splitBrainHandlerService, nodeEngine);
        this.service = (ReplicatedMapService)nodeEngine.getService("hz:impl:replicatedMapService");
    }

    @Override
    protected void mergeStore(ReplicatedRecordStore store, BiConsumer<Integer, SplitBrainMergeTypes.ReplicatedMapMergeTypes> consumer) {
        int partitionId = store.getPartitionId();
        Iterator<ReplicatedRecord> iterator = store.recordIterator();
        while (iterator.hasNext()) {
            ReplicatedRecord record = iterator.next();
            SplitBrainMergeTypes.ReplicatedMapMergeTypes mergingEntry = MergingValueFactory.createMergingEntry((SerializationService)this.getSerializationService(), record);
            consumer.accept(partitionId, mergingEntry);
        }
    }

    @Override
    protected void mergeStoreLegacy(ReplicatedRecordStore store, BiConsumer<Integer, Operation> consumer) {
        int partitionId = store.getPartitionId();
        String name = store.getName();
        ReplicatedMapMergePolicy mergePolicy = (ReplicatedMapMergePolicy)this.getMergePolicy(name);
        Iterator<ReplicatedRecord> iterator = store.recordIterator();
        while (iterator.hasNext()) {
            ReplicatedRecord record = iterator.next();
            ReplicatedMapEntryView entryView = ReplicatedMapMergeRunnable.createEntryView(record, this.getSerializationService());
            LegacyMergeOperation operation = new LegacyMergeOperation(name, record.getKeyInternal(), entryView, mergePolicy);
            consumer.accept(partitionId, operation);
        }
    }

    private static ReplicatedMapEntryView createEntryView(ReplicatedRecord record, SerializationService ss) {
        return new ReplicatedMapEntryView(ss).setKey(record.getKeyInternal()).setValue(record.getValueInternal()).setHits(record.getHits()).setTtl(record.getTtlMillis()).setLastAccessTime(record.getLastAccessTime()).setCreationTime(record.getCreationTime()).setLastUpdateTime(record.getUpdateTime());
    }

    @Override
    protected int getBatchSize(String dataStructureName) {
        ReplicatedMapConfig replicatedMapConfig = this.getReplicatedMapConfig(dataStructureName);
        MergePolicyConfig mergePolicyConfig = replicatedMapConfig.getMergePolicyConfig();
        return mergePolicyConfig.getBatchSize();
    }

    @Override
    protected InMemoryFormat getInMemoryFormat(String dataStructureName) {
        ReplicatedMapConfig replicatedMapConfig = this.getReplicatedMapConfig(dataStructureName);
        return replicatedMapConfig.getInMemoryFormat();
    }

    @Override
    protected Object getMergePolicy(String dataStructureName) {
        return this.service.getMergePolicy(dataStructureName);
    }

    @Override
    protected String getDataStructureName(ReplicatedRecordStore replicatedRecordStore) {
        return replicatedRecordStore.getName();
    }

    @Override
    protected int getPartitionId(ReplicatedRecordStore replicatedRecordStore) {
        return replicatedRecordStore.getPartitionId();
    }

    @Override
    protected OperationFactory createMergeOperationFactory(String dataStructureName, SplitBrainMergePolicy<Object, SplitBrainMergeTypes.ReplicatedMapMergeTypes> mergePolicy, int[] partitions, List<SplitBrainMergeTypes.ReplicatedMapMergeTypes>[] entries) {
        return new MergeOperationFactory(dataStructureName, partitions, entries, mergePolicy);
    }

    private ReplicatedMapConfig getReplicatedMapConfig(String name) {
        return this.service.getReplicatedMapConfig(name);
    }
}

