/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.ringbuffer.impl.operations;

import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.nio.serialization.Data;
import com.atlassian.nutcluster.ringbuffer.OverflowPolicy;
import com.atlassian.nutcluster.ringbuffer.impl.RingbufferContainer;
import com.atlassian.nutcluster.ringbuffer.impl.operations.AbstractRingBufferOperation;
import com.atlassian.nutcluster.ringbuffer.impl.operations.AddBackupOperation;
import com.atlassian.nutcluster.spi.BackupAwareOperation;
import com.atlassian.nutcluster.spi.Notifier;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.spi.WaitNotifyKey;
import com.atlassian.nutcluster.spi.impl.MutatingOperation;
import java.io.IOException;

public class AddOperation
extends AbstractRingBufferOperation
implements Notifier,
BackupAwareOperation,
MutatingOperation {
    private Data item;
    private long resultSequence;
    private OverflowPolicy overflowPolicy;

    public AddOperation() {
    }

    public AddOperation(String name, Data item, OverflowPolicy overflowPolicy) {
        super(name);
        this.item = item;
        this.overflowPolicy = overflowPolicy;
    }

    @Override
    public void run() throws Exception {
        RingbufferContainer ringbuffer = this.getRingBufferContainer();
        if (this.overflowPolicy == OverflowPolicy.FAIL && ringbuffer.remainingCapacity() < 1L) {
            this.resultSequence = -1L;
            return;
        }
        this.resultSequence = ringbuffer.add(this.item);
    }

    @Override
    public WaitNotifyKey getNotifiedKey() {
        RingbufferContainer ringbuffer = this.getRingBufferContainer();
        return ringbuffer.getRingEmptyWaitNotifyKey();
    }

    @Override
    public boolean shouldNotify() {
        return this.resultSequence != -1L;
    }

    @Override
    public boolean shouldBackup() {
        return this.resultSequence != -1L;
    }

    @Override
    public int getSyncBackupCount() {
        RingbufferContainer ringbuffer = this.getRingBufferContainer();
        return ringbuffer.getConfig().getBackupCount();
    }

    @Override
    public int getAsyncBackupCount() {
        RingbufferContainer ringbuffer = this.getRingBufferContainer();
        return ringbuffer.getConfig().getAsyncBackupCount();
    }

    @Override
    public Operation getBackupOperation() {
        return new AddBackupOperation(this.name, this.resultSequence, this.item);
    }

    @Override
    public Long getResponse() {
        return this.resultSequence;
    }

    @Override
    public int getId() {
        return 3;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeData(this.item);
        out.writeInt(this.overflowPolicy.getId());
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.item = in.readData();
        this.overflowPolicy = OverflowPolicy.getById(in.readInt());
    }
}

