/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.scheduledexecutor.impl.operations;

import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.nio.serialization.IdentifiedDataSerializable;
import com.atlassian.nutcluster.scheduledexecutor.impl.DistributedScheduledExecutorService;
import com.atlassian.nutcluster.scheduledexecutor.impl.ScheduledExecutorContainer;
import com.atlassian.nutcluster.scheduledexecutor.impl.ScheduledExecutorDataSerializerHook;
import com.atlassian.nutcluster.spi.NamedOperation;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.spi.PartitionAwareOperation;
import java.io.IOException;
import java.util.concurrent.RejectedExecutionException;

public abstract class AbstractSchedulerOperation
extends Operation
implements NamedOperation,
PartitionAwareOperation,
IdentifiedDataSerializable {
    protected String schedulerName;

    AbstractSchedulerOperation() {
    }

    AbstractSchedulerOperation(String schedulerName) {
        this.schedulerName = schedulerName;
    }

    public String getSchedulerName() {
        return this.schedulerName;
    }

    @Override
    public String getName() {
        return this.schedulerName;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:scheduledExecutorService";
    }

    @Override
    public int getFactoryId() {
        return ScheduledExecutorDataSerializerHook.F_ID;
    }

    public ScheduledExecutorContainer getContainer() {
        this.checkNotShutdown();
        DistributedScheduledExecutorService service = (DistributedScheduledExecutorService)this.getService();
        return service.getPartitionOrMemberBin(this.getPartitionId()).getOrCreateContainer(this.schedulerName);
    }

    private void checkNotShutdown() {
        DistributedScheduledExecutorService service = (DistributedScheduledExecutorService)this.getService();
        if (service.isShutdown(this.getSchedulerName())) {
            throw new RejectedExecutionException("Executor is shut down.");
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.schedulerName);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.schedulerName = in.readUTF();
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", name=").append(this.schedulerName);
        sb.append(", partiotionId=").append(this.getPartitionId());
    }
}

