/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.spi.impl;

import com.atlassian.nutcluster.config.Config;
import com.atlassian.nutcluster.core.NutclusterException;
import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.instance.MemberImpl;
import com.atlassian.nutcluster.instance.Node;
import com.atlassian.nutcluster.instance.NodeExtension;
import com.atlassian.nutcluster.internal.cluster.ClusterService;
import com.atlassian.nutcluster.internal.diagnostics.Diagnostics;
import com.atlassian.nutcluster.internal.dynamicconfig.ClusterWideConfigurationService;
import com.atlassian.nutcluster.internal.dynamicconfig.DynamicConfigListener;
import com.atlassian.nutcluster.internal.management.ManagementCenterService;
import com.atlassian.nutcluster.internal.metrics.MetricsRegistry;
import com.atlassian.nutcluster.internal.metrics.ProbeLevel;
import com.atlassian.nutcluster.internal.metrics.impl.MetricsRegistryImpl;
import com.atlassian.nutcluster.internal.metrics.metricsets.ClassLoadingMetricSet;
import com.atlassian.nutcluster.internal.metrics.metricsets.FileMetricSet;
import com.atlassian.nutcluster.internal.metrics.metricsets.GarbageCollectionMetricSet;
import com.atlassian.nutcluster.internal.metrics.metricsets.OperatingSystemMetricSet;
import com.atlassian.nutcluster.internal.metrics.metricsets.RuntimeMetricSet;
import com.atlassian.nutcluster.internal.metrics.metricsets.StatisticsAwareMetricsSet;
import com.atlassian.nutcluster.internal.metrics.metricsets.ThreadMetricSet;
import com.atlassian.nutcluster.internal.partition.InternalPartitionService;
import com.atlassian.nutcluster.internal.partition.MigrationInfo;
import com.atlassian.nutcluster.internal.usercodedeployment.UserCodeDeploymentClassLoader;
import com.atlassian.nutcluster.internal.usercodedeployment.UserCodeDeploymentService;
import com.atlassian.nutcluster.logging.ILogger;
import com.atlassian.nutcluster.logging.LoggingService;
import com.atlassian.nutcluster.logging.LoggingServiceImpl;
import com.atlassian.nutcluster.nio.Address;
import com.atlassian.nutcluster.nio.Packet;
import com.atlassian.nutcluster.nio.serialization.Data;
import com.atlassian.nutcluster.quorum.impl.QuorumServiceImpl;
import com.atlassian.nutcluster.spi.NodeEngine;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.spi.PostJoinAwareService;
import com.atlassian.nutcluster.spi.PreJoinAwareService;
import com.atlassian.nutcluster.spi.SharedService;
import com.atlassian.nutcluster.spi.exception.RetryableNutclusterException;
import com.atlassian.nutcluster.spi.exception.ServiceNotFoundException;
import com.atlassian.nutcluster.spi.impl.PacketDispatcher;
import com.atlassian.nutcluster.spi.impl.eventservice.InternalEventService;
import com.atlassian.nutcluster.spi.impl.eventservice.impl.EventServiceImpl;
import com.atlassian.nutcluster.spi.impl.executionservice.InternalExecutionService;
import com.atlassian.nutcluster.spi.impl.executionservice.impl.ExecutionServiceImpl;
import com.atlassian.nutcluster.spi.impl.operationparker.OperationParker;
import com.atlassian.nutcluster.spi.impl.operationparker.impl.OperationParkerImpl;
import com.atlassian.nutcluster.spi.impl.operationservice.InternalOperationService;
import com.atlassian.nutcluster.spi.impl.operationservice.impl.OperationServiceImpl;
import com.atlassian.nutcluster.spi.impl.proxyservice.InternalProxyService;
import com.atlassian.nutcluster.spi.impl.proxyservice.impl.ProxyServiceImpl;
import com.atlassian.nutcluster.spi.impl.servicemanager.ServiceInfo;
import com.atlassian.nutcluster.spi.impl.servicemanager.ServiceManager;
import com.atlassian.nutcluster.spi.impl.servicemanager.impl.ServiceManagerImpl;
import com.atlassian.nutcluster.spi.merge.SplitBrainMergePolicyProvider;
import com.atlassian.nutcluster.spi.properties.NutclusterProperties;
import com.atlassian.nutcluster.spi.serialization.SerializationService;
import com.atlassian.nutcluster.transaction.TransactionManagerService;
import com.atlassian.nutcluster.transaction.impl.TransactionManagerServiceImpl;
import com.atlassian.nutcluster.util.EmptyStatement;
import com.atlassian.nutcluster.util.ExceptionUtil;
import com.atlassian.nutcluster.util.function.Consumer;
import com.atlassian.nutcluster.version.MemberVersion;
import com.atlassian.nutcluster.wan.WanReplicationService;
import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.Nonnull;

public class NodeEngineImpl
implements NodeEngine {
    private static final String JET_SERVICE_NAME = "hz:impl:jetService";
    private final Node node;
    private final SerializationService serializationService;
    private final LoggingServiceImpl loggingService;
    private final ILogger logger;
    private final MetricsRegistryImpl metricsRegistry;
    private final ProxyServiceImpl proxyService;
    private final ServiceManagerImpl serviceManager;
    private final ExecutionServiceImpl executionService;
    private final OperationServiceImpl operationService;
    private final EventServiceImpl eventService;
    private final OperationParkerImpl operationParker;
    private final ClusterWideConfigurationService configurationService;
    private final TransactionManagerServiceImpl transactionManagerService;
    private final WanReplicationService wanReplicationService;
    private final Consumer<Packet> packetDispatcher;
    private final QuorumServiceImpl quorumService;
    private final Diagnostics diagnostics;
    private final SplitBrainMergePolicyProvider splitBrainMergePolicyProvider;

    public NodeEngineImpl(Node node) {
        this.node = node;
        try {
            this.serializationService = node.getSerializationService();
            this.loggingService = node.loggingService;
            this.logger = node.getLogger(NodeEngine.class.getName());
            this.metricsRegistry = this.newMetricRegistry(node);
            this.proxyService = new ProxyServiceImpl(this);
            this.serviceManager = new ServiceManagerImpl(this);
            this.executionService = new ExecutionServiceImpl(this);
            this.operationService = new OperationServiceImpl(this);
            this.eventService = new EventServiceImpl(this);
            this.operationParker = new OperationParkerImpl(this);
            UserCodeDeploymentService userCodeDeploymentService = new UserCodeDeploymentService();
            DynamicConfigListener dynamicConfigListener = node.getNodeExtension().createDynamicConfigListener();
            this.configurationService = new ClusterWideConfigurationService(this, dynamicConfigListener);
            ClassLoader configClassLoader = node.getConfigClassLoader();
            if (configClassLoader instanceof UserCodeDeploymentClassLoader) {
                ((UserCodeDeploymentClassLoader)configClassLoader).setUserCodeDeploymentService(userCodeDeploymentService);
            }
            this.transactionManagerService = new TransactionManagerServiceImpl(this);
            this.wanReplicationService = node.getNodeExtension().createService(WanReplicationService.class);
            this.packetDispatcher = new PacketDispatcher(this.logger, this.operationService.getOperationExecutor(), (Consumer<Packet>)this.operationService.getInboundResponseHandlerSupplier().get(), this.operationService.getInvocationMonitor(), this.eventService, this.getJetPacketConsumer(node.getNodeExtension()));
            this.quorumService = new QuorumServiceImpl(this);
            this.diagnostics = this.newDiagnostics();
            this.splitBrainMergePolicyProvider = new SplitBrainMergePolicyProvider(this);
            this.serviceManager.registerService("hz:impl:operationService", this.operationService);
            this.serviceManager.registerService("hz:impl:operationParker", this.operationParker);
            this.serviceManager.registerService("user-code-deployment-service", userCodeDeploymentService);
            this.serviceManager.registerService("configuration-service", this.configurationService);
        }
        catch (Throwable e) {
            try {
                this.shutdown(true);
            }
            catch (Throwable ignored) {
                EmptyStatement.ignore(ignored);
            }
            throw ExceptionUtil.rethrow(e);
        }
    }

    private MetricsRegistryImpl newMetricRegistry(Node node) {
        ProbeLevel probeLevel = node.getProperties().getEnum(Diagnostics.METRICS_LEVEL, ProbeLevel.class);
        return new MetricsRegistryImpl(this.getNutclusterInstance().getName(), node.getLogger(MetricsRegistry.class), probeLevel);
    }

    private Diagnostics newDiagnostics() {
        Address address = this.node.getThisAddress();
        String addressString = address.getHost().replace(":", "_") + "_" + address.getPort();
        String name = "diagnostics-" + addressString + "-" + System.currentTimeMillis();
        return new Diagnostics(name, this.loggingService.getLogger(Diagnostics.class), this.getNutclusterInstance().getName(), this.node.getProperties());
    }

    public LoggingService getLoggingService() {
        return this.loggingService;
    }

    public MetricsRegistry getMetricsRegistry() {
        return this.metricsRegistry;
    }

    public void start() {
        RuntimeMetricSet.register(this.metricsRegistry);
        GarbageCollectionMetricSet.register(this.metricsRegistry);
        OperatingSystemMetricSet.register(this.metricsRegistry);
        ThreadMetricSet.register(this.metricsRegistry);
        ClassLoadingMetricSet.register(this.metricsRegistry);
        FileMetricSet.register(this.metricsRegistry);
        if (this.node.getProperties().getBoolean(Diagnostics.METRICS_DISTRIBUTED_DATASTRUCTURES)) {
            new StatisticsAwareMetricsSet(this.serviceManager, this).register(this.metricsRegistry);
        }
        this.metricsRegistry.scanAndRegister(this.node.getNodeExtension().getMemoryStats(), "memory");
        this.metricsRegistry.collectMetrics(this.operationService, this.proxyService, this.eventService, this.operationParker);
        this.serviceManager.start();
        this.proxyService.init();
        this.operationService.start();
        this.quorumService.start();
        this.diagnostics.start();
        this.node.getNodeExtension().registerPlugins(this.diagnostics);
    }

    public Consumer<Packet> getPacketDispatcher() {
        return this.packetDispatcher;
    }

    public Diagnostics getDiagnostics() {
        return this.diagnostics;
    }

    public ClusterWideConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    @Override
    public Address getThisAddress() {
        return this.node.getThisAddress();
    }

    @Override
    public Address getMasterAddress() {
        return this.node.getMasterAddress();
    }

    @Override
    public MemberImpl getLocalMember() {
        return this.node.getLocalMember();
    }

    @Override
    public Config getConfig() {
        return this.node.getConfig();
    }

    @Override
    public ClassLoader getConfigClassLoader() {
        return this.node.getConfigClassLoader();
    }

    @Override
    public InternalEventService getEventService() {
        return this.eventService;
    }

    @Override
    public SerializationService getSerializationService() {
        return this.serializationService;
    }

    @Override
    public InternalOperationService getOperationService() {
        return this.operationService;
    }

    @Override
    public InternalExecutionService getExecutionService() {
        return this.executionService;
    }

    @Override
    public InternalPartitionService getPartitionService() {
        return this.node.getPartitionService();
    }

    @Override
    public ClusterService getClusterService() {
        return this.node.getClusterService();
    }

    public ManagementCenterService getManagementCenterService() {
        return this.node.getManagementCenterService();
    }

    @Override
    public InternalProxyService getProxyService() {
        return this.proxyService;
    }

    public OperationParker getOperationParker() {
        return this.operationParker;
    }

    @Override
    public WanReplicationService getWanReplicationService() {
        return this.wanReplicationService;
    }

    @Override
    public QuorumServiceImpl getQuorumService() {
        return this.quorumService;
    }

    @Override
    public TransactionManagerService getTransactionManagerService() {
        return this.transactionManagerService;
    }

    @Override
    public Data toData(Object object) {
        return this.serializationService.toData(object);
    }

    @Override
    public <T> T toObject(Object object) {
        return this.serializationService.toObject(object);
    }

    @Override
    public <T> T toObject(Object object, Class klazz) {
        return this.serializationService.toObject(object, klazz);
    }

    @Override
    public boolean isActive() {
        return this.isRunning();
    }

    @Override
    public boolean isRunning() {
        return this.node.isRunning();
    }

    @Override
    public NutclusterInstance getNutclusterInstance() {
        return this.node.nutclusterInstance;
    }

    @Override
    public ILogger getLogger(String name) {
        return this.loggingService.getLogger(name);
    }

    @Override
    public ILogger getLogger(Class clazz) {
        return this.loggingService.getLogger(clazz);
    }

    @Override
    public NutclusterProperties getProperties() {
        return this.node.getProperties();
    }

    @Override
    public <T> T getService(String serviceName) {
        Object service = this.serviceManager.getService(serviceName);
        if (service == null) {
            if (this.isRunning()) {
                throw new NutclusterException("Service with name '" + serviceName + "' not found!", new ServiceNotFoundException("Service with name '" + serviceName + "' not found!"));
            }
            throw new RetryableNutclusterException("NutclusterInstance[" + String.valueOf(this.getThisAddress()) + "] is not active!");
        }
        return service;
    }

    @Override
    public <T extends SharedService> T getSharedService(String serviceName) {
        return this.serviceManager.getSharedService(serviceName);
    }

    @Override
    public MemberVersion getVersion() {
        return this.node.getVersion();
    }

    @Override
    public SplitBrainMergePolicyProvider getSplitBrainMergePolicyProvider() {
        return this.splitBrainMergePolicyProvider;
    }

    @Override
    public <S> Collection<S> getServices(Class<S> serviceClass) {
        return this.serviceManager.getServices(serviceClass);
    }

    public Collection<ServiceInfo> getServiceInfos(Class serviceClass) {
        return this.serviceManager.getServiceInfos(serviceClass);
    }

    public Node getNode() {
        return this.node;
    }

    public void onMemberLeft(MemberImpl member) {
        this.operationParker.onMemberLeft(member);
        this.operationService.onMemberLeft(member);
        this.eventService.onMemberLeft(member);
    }

    public void onClientDisconnected(String clientUuid) {
        this.operationParker.onClientDisconnected(clientUuid);
    }

    public void onPartitionMigrate(MigrationInfo migrationInfo) {
        this.operationParker.onPartitionMigrate(migrationInfo);
    }

    public Operation[] getPostJoinOperations() {
        LinkedList<Operation> postJoinOps = new LinkedList<Operation>();
        Collection<PostJoinAwareService> services = this.getServices(PostJoinAwareService.class);
        for (PostJoinAwareService service : services) {
            Operation postJoinOperation = service.getPostJoinOperation();
            if (postJoinOperation == null) continue;
            if (postJoinOperation.getPartitionId() >= 0) {
                this.logger.severe("Post-join operations should not have partition ID set! Service: " + String.valueOf(service) + ", Operation: " + String.valueOf(postJoinOperation));
                continue;
            }
            postJoinOps.add(postJoinOperation);
        }
        return postJoinOps.isEmpty() ? null : postJoinOps.toArray(new Operation[0]);
    }

    public Operation[] getPreJoinOperations() {
        LinkedList<Operation> preJoinOps = new LinkedList<Operation>();
        Collection<PreJoinAwareService> services = this.getServices(PreJoinAwareService.class);
        for (PreJoinAwareService service : services) {
            Operation preJoinOperation = service.getPreJoinOperation();
            if (preJoinOperation == null) continue;
            if (preJoinOperation.getPartitionId() >= 0) {
                this.logger.severe("Pre-join operations operations should not have partition ID set! Service: " + String.valueOf(service) + ", Operation: " + String.valueOf(preJoinOperation));
                continue;
            }
            preJoinOps.add(preJoinOperation);
        }
        return preJoinOps.isEmpty() ? null : preJoinOps.toArray(new Operation[0]);
    }

    public void reset() {
        this.operationParker.reset();
        this.operationService.reset();
    }

    public void shutdown(boolean terminate) {
        this.logger.finest("Shutting down services...");
        if (this.operationParker != null) {
            this.operationParker.shutdown();
        }
        if (this.operationService != null) {
            this.operationService.shutdownInvocations();
        }
        if (this.proxyService != null) {
            this.proxyService.shutdown();
        }
        if (this.serviceManager != null) {
            this.serviceManager.shutdown(terminate);
        }
        if (this.eventService != null) {
            this.eventService.shutdown();
        }
        if (this.operationService != null) {
            this.operationService.shutdownOperationExecutor();
        }
        if (this.wanReplicationService != null) {
            this.wanReplicationService.shutdown();
        }
        if (this.executionService != null) {
            this.executionService.shutdown();
        }
        if (this.metricsRegistry != null) {
            this.metricsRegistry.shutdown();
        }
        if (this.diagnostics != null) {
            this.diagnostics.shutdown();
        }
    }

    @Nonnull
    private Consumer<Packet> getJetPacketConsumer(NodeExtension nodeExtension) {
        if (nodeExtension instanceof JetPacketConsumer) {
            return (JetPacketConsumer)((Object)nodeExtension);
        }
        return new JetPacketConsumer(this){

            @Override
            public void accept(Packet packet) {
                throw new UnsupportedOperationException("Jet is not registered on this node");
            }
        };
    }

    public static interface JetPacketConsumer
    extends Consumer<Packet> {
    }
}

