/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.spi.impl.operationservice.impl;

import com.atlassian.nutcluster.instance.EndpointQualifier;
import com.atlassian.nutcluster.instance.Node;
import com.atlassian.nutcluster.internal.serialization.InternalSerializationService;
import com.atlassian.nutcluster.nio.Address;
import com.atlassian.nutcluster.nio.Connection;
import com.atlassian.nutcluster.nio.Packet;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.util.Preconditions;

public class OutboundOperationHandler {
    private final Address thisAddress;
    private final InternalSerializationService serializationService;
    private final Node node;

    public OutboundOperationHandler(Node node, InternalSerializationService serializationService) {
        this.node = node;
        this.thisAddress = node.getThisAddress();
        this.serializationService = serializationService;
    }

    public boolean send(Operation op, Address target) {
        Preconditions.checkNotNull(target, "Target is required!");
        if (this.thisAddress.equals(target)) {
            throw new IllegalArgumentException("Target is this node! -> " + String.valueOf(target) + ", op: " + String.valueOf(op));
        }
        Object connection = this.node.getNetworkingService().getEndpointManager(EndpointQualifier.MEMBER).getOrConnect(target);
        return this.send(op, (Connection)connection);
    }

    public boolean send(Operation op, Connection connection) {
        byte[] bytes = this.serializationService.toBytes(op);
        int partitionId = op.getPartitionId();
        Packet packet = new Packet(bytes, partitionId).setPacketType(Packet.Type.OPERATION);
        if (op.isUrgent()) {
            packet.raiseFlags(16);
        }
        return this.node.getEndpointManager(EndpointQualifier.MEMBER).transmit(packet, connection);
    }
}

