/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.spi.properties;

import com.atlassian.nutcluster.config.Config;
import com.atlassian.nutcluster.spi.properties.NutclusterProperty;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class NutclusterProperties {
    private final Set<String> keys;
    private final Properties properties = new Properties();

    public NutclusterProperties(Config config) {
        this(config.getProperties());
    }

    public NutclusterProperties(Properties nullableProperties) {
        if (nullableProperties != null) {
            this.properties.putAll((Map<?, ?>)nullableProperties);
        }
        this.keys = Collections.unmodifiableSet(this.properties.keySet());
    }

    public Set<String> keySet() {
        return this.keys;
    }

    public String get(String key) {
        return (String)this.properties.get(key);
    }

    public String getString(NutclusterProperty property) {
        String value = this.properties.getProperty(property.getName());
        if (value != null) {
            return value;
        }
        value = property.getSystemProperty();
        if (value != null) {
            return value;
        }
        NutclusterProperty parent = property.getParent();
        if (parent != null) {
            return this.getString(parent);
        }
        String deprecatedName = property.getDeprecatedName();
        if (deprecatedName != null) {
            value = this.get(deprecatedName);
            if (value == null) {
                value = System.getProperty(deprecatedName);
            }
            if (value != null) {
                System.err.print("Don't use deprecated '" + deprecatedName + "' but use '" + property.getName() + "' instead. The former name will be removed in the next Nutcluster release.");
                return value;
            }
        }
        return property.getDefaultValue();
    }

    public boolean containsKey(NutclusterProperty property) {
        if (property == null) {
            return false;
        }
        return this.containsKey(property.getName()) || this.containsKey(property.getParent()) || this.containsKey(property.getDeprecatedName());
    }

    private boolean containsKey(String propertyName) {
        if (propertyName == null) {
            return false;
        }
        return this.properties.containsKey(propertyName) || System.getProperty(propertyName) != null;
    }

    public boolean getBoolean(NutclusterProperty property) {
        return Boolean.valueOf(this.getString(property));
    }

    public int getInteger(NutclusterProperty property) {
        return Integer.parseInt(this.getString(property));
    }

    public long getLong(NutclusterProperty property) {
        return Long.parseLong(this.getString(property));
    }

    public float getFloat(NutclusterProperty property) {
        return Float.valueOf(this.getString(property)).floatValue();
    }

    public double getDouble(NutclusterProperty property) {
        return Double.valueOf(this.getString(property));
    }

    public long getNanos(NutclusterProperty property) {
        TimeUnit timeUnit = property.getTimeUnit();
        return timeUnit.toNanos(this.getLong(property));
    }

    public long getMillis(NutclusterProperty property) {
        TimeUnit timeUnit = property.getTimeUnit();
        return timeUnit.toMillis(this.getLong(property));
    }

    public long getPositiveMillisOrDefault(NutclusterProperty property) {
        return this.getPositiveMillisOrDefault(property, Long.parseLong(property.getDefaultValue()));
    }

    public long getPositiveMillisOrDefault(NutclusterProperty property, long defaultValue) {
        long millis = this.getMillis(property);
        return millis > 0L ? millis : defaultValue;
    }

    public int getSeconds(NutclusterProperty property) {
        TimeUnit timeUnit = property.getTimeUnit();
        return (int)timeUnit.toSeconds(this.getLong(property));
    }

    public <E extends Enum> E getEnum(NutclusterProperty property, Class<E> enumClazz) {
        String value = this.getString(property);
        for (Enum enumConstant : (Enum[])enumClazz.getEnumConstants()) {
            if (!enumConstant.name().equalsIgnoreCase(value)) continue;
            return (E)enumConstant;
        }
        throw new IllegalArgumentException(String.format("value '%s' for property '%s' is not a valid %s value", value, property.getName(), enumClazz.getName()));
    }
}

