/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.topic.impl;

import com.atlassian.nutcluster.nio.Address;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.nio.serialization.Data;
import com.atlassian.nutcluster.nio.serialization.IdentifiedDataSerializable;
import com.atlassian.nutcluster.topic.impl.TopicDataSerializerHook;
import com.atlassian.nutcluster.util.Clock;
import java.io.IOException;

class TopicEvent
implements IdentifiedDataSerializable {
    String name;
    long publishTime;
    Address publisherAddress;
    Data data;

    public TopicEvent() {
    }

    TopicEvent(String name, Data data, Address publisherAddress) {
        this.name = name;
        this.publishTime = Clock.currentTimeMillis();
        this.publisherAddress = publisherAddress;
        this.data = data;
    }

    @Override
    public int getFactoryId() {
        return TopicDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 1;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeLong(this.publishTime);
        out.writeObject(this.publisherAddress);
        out.writeData(this.data);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.publishTime = in.readLong();
        this.publisherAddress = (Address)in.readObject();
        this.data = in.readData();
    }

    public String toString() {
        return "TopicEvent{name='" + this.name + "', publishTime=" + this.publishTime + ", publisherAddress=" + String.valueOf(this.publisherAddress) + "}";
    }
}

