/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.topic.impl;

import com.atlassian.nutcluster.config.ListenerConfig;
import com.atlassian.nutcluster.config.TopicConfig;
import com.atlassian.nutcluster.core.MessageListener;
import com.atlassian.nutcluster.core.NutclusterInstanceAware;
import com.atlassian.nutcluster.monitor.LocalTopicStats;
import com.atlassian.nutcluster.monitor.impl.LocalTopicStatsImpl;
import com.atlassian.nutcluster.nio.ClassLoaderUtil;
import com.atlassian.nutcluster.spi.AbstractDistributedObject;
import com.atlassian.nutcluster.spi.InitializingObject;
import com.atlassian.nutcluster.spi.NodeEngine;
import com.atlassian.nutcluster.topic.impl.TopicService;
import com.atlassian.nutcluster.util.ExceptionUtil;

public abstract class TopicProxySupport
extends AbstractDistributedObject<TopicService>
implements InitializingObject {
    private final String name;
    private final ClassLoader configClassLoader;
    private final TopicService topicService;
    private final LocalTopicStatsImpl topicStats;
    private boolean multithreaded;

    public TopicProxySupport(String name, NodeEngine nodeEngine, TopicService service) {
        super(nodeEngine, service);
        this.name = name;
        this.configClassLoader = nodeEngine.getConfigClassLoader();
        this.topicService = service;
        this.topicStats = this.topicService.getLocalTopicStats(name);
    }

    @Override
    public void initialize() {
        NodeEngine nodeEngine = this.getNodeEngine();
        TopicConfig config = nodeEngine.getConfig().findTopicConfig(this.name);
        this.multithreaded = config.isMultiThreadingEnabled();
        for (ListenerConfig listenerConfig : config.getMessageListenerConfigs()) {
            this.initialize(listenerConfig);
        }
    }

    private void initialize(ListenerConfig listenerConfig) {
        NodeEngine nodeEngine = this.getNodeEngine();
        MessageListener listener = this.loadListener(listenerConfig);
        if (listener == null) {
            return;
        }
        if (listener instanceof NutclusterInstanceAware) {
            NutclusterInstanceAware NutclusterInstanceAware2 = (NutclusterInstanceAware)((Object)listener);
            NutclusterInstanceAware2.setNutclusterInstance(nodeEngine.getNutclusterInstance());
        }
        this.addMessageListenerInternal(listener);
    }

    private MessageListener loadListener(ListenerConfig listenerConfig) {
        try {
            MessageListener listener = (MessageListener)listenerConfig.getImplementation();
            if (listener == null && listenerConfig.getClassName() != null) {
                listener = (MessageListener)ClassLoaderUtil.newInstance(this.configClassLoader, listenerConfig.getClassName());
            }
            return listener;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    public LocalTopicStats getLocalTopicStatsInternal() {
        return this.topicService.getLocalTopicStats(this.name);
    }

    public void publishInternal(Object message) {
        this.topicStats.incrementPublishes();
        this.topicService.publishMessage(this.name, message, this.multithreaded);
    }

    public String addMessageListenerInternal(MessageListener listener) {
        return this.topicService.addMessageListener(this.name, listener, false);
    }

    public boolean removeMessageListenerInternal(String registrationId) {
        return this.topicService.removeMessageListener(this.name, registrationId);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:topicService";
    }

    @Override
    public String getName() {
        return this.name;
    }
}

