/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.topic.impl.reliable;

import com.atlassian.nutcluster.core.Member;
import com.atlassian.nutcluster.internal.cluster.ClusterService;
import com.atlassian.nutcluster.logging.ILogger;
import com.atlassian.nutcluster.ringbuffer.StaleSequenceException;
import com.atlassian.nutcluster.spi.serialization.SerializationService;
import com.atlassian.nutcluster.topic.ReliableMessageListener;
import com.atlassian.nutcluster.topic.impl.reliable.MessageRunner;
import com.atlassian.nutcluster.topic.impl.reliable.ReliableTopicMessage;
import com.atlassian.nutcluster.topic.impl.reliable.ReliableTopicProxy;
import java.util.concurrent.Executor;

public class ReliableMessageRunner<E>
extends MessageRunner<E> {
    private final ClusterService clusterService;
    private final ReliableTopicProxy<E> proxy;

    ReliableMessageRunner(String id, ReliableMessageListener<E> listener, SerializationService serializationService, Executor executor, ILogger logger, ClusterService clusterService, ReliableTopicProxy<E> proxy) {
        super(id, listener, proxy.ringbuffer, proxy.getName(), proxy.topicConfig.getReadBatchSize(), serializationService, executor, proxy.runnersMap, logger);
        this.clusterService = clusterService;
        this.proxy = proxy;
    }

    @Override
    protected void updateStatistics() {
        this.proxy.localTopicStats.incrementReceives();
    }

    @Override
    protected Member getMember(ReliableTopicMessage m) {
        return this.clusterService.getMember(m.getPublisherAddress());
    }

    @Override
    protected Throwable adjustThrowable(Throwable t) {
        return t;
    }

    @Override
    protected long getHeadSequence(StaleSequenceException staleSequenceException) {
        return staleSequenceException.getHeadSeq();
    }
}

