/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.transaction.impl.operations;

import com.atlassian.nutcluster.core.MemberLeftException;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.spi.ExceptionAction;
import com.atlassian.nutcluster.spi.exception.TargetNotMemberException;
import com.atlassian.nutcluster.transaction.impl.TransactionManagerServiceImpl;
import com.atlassian.nutcluster.transaction.impl.operations.AbstractTxOperation;
import java.io.IOException;

public class RollbackTxBackupLogOperation
extends AbstractTxOperation {
    private String txnId;

    public RollbackTxBackupLogOperation() {
    }

    public RollbackTxBackupLogOperation(String txnId) {
        this.txnId = txnId;
    }

    @Override
    public void run() throws Exception {
        TransactionManagerServiceImpl txManagerService = (TransactionManagerServiceImpl)this.getService();
        txManagerService.rollbackBackupLog(this.txnId);
    }

    @Override
    public Object getResponse() {
        return true;
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        if (throwable instanceof MemberLeftException || throwable instanceof TargetNotMemberException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onInvocationException(throwable);
    }

    @Override
    public int getId() {
        return 4;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.txnId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.txnId = in.readUTF();
    }
}

