/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.backuprestore;

import com.atlassian.confluence.api.model.backuprestore.JobScope;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FileInfo {
    @JsonProperty
    @Schema(example="backup-2020-01-01-01-01-01.zip")
    public final String name;
    @JsonProperty
    @Schema(example="2020-01-01T01:01:01.000Z")
    public final String creationTime;
    @JsonProperty
    @Schema(example="1000")
    public final long size;
    @JsonProperty
    @Schema(example="SITE")
    public final JobScope jobScope;

    @JsonCreator
    private FileInfo() {
        this(FileInfo.builder());
    }

    public FileInfo(String name, String creationTime, long size, JobScope jobScope) {
        this.name = name;
        this.creationTime = creationTime;
        this.size = size;
        this.jobScope = jobScope;
    }

    private FileInfo(Builder builder) {
        this.name = builder.name;
        this.creationTime = builder.creationTime;
        this.size = builder.size;
        this.jobScope = builder.jobScope;
    }

    public String getName() {
        return this.name;
    }

    public String getCreationTime() {
        return this.creationTime;
    }

    public long getSize() {
        return this.size;
    }

    public JobScope getJobScope() {
        return this.jobScope;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "[" + this.name + "] [" + this.creationTime + "] [" + this.size + "] [" + String.valueOf((Object)this.jobScope) + "]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FileInfo)) {
            return false;
        }
        FileInfo fileInfo = (FileInfo)obj;
        return Objects.equals(fileInfo.name, this.name) && Objects.equals(fileInfo.creationTime, this.creationTime) && Objects.equals(fileInfo.size, this.size) && Objects.equals((Object)fileInfo.jobScope, (Object)this.jobScope);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.creationTime, this.size, this.jobScope});
    }

    public static class Builder {
        private String name = "";
        private String creationTime = OffsetDateTime.now().toString();
        private long size;
        private JobScope jobScope;

        public Builder name(@NonNull String name) {
            this.name = name;
            return this;
        }

        public Builder creationTime(@NonNull String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public Builder size(long size) {
            this.size = size;
            return this;
        }

        public Builder jobScope(JobScope jobScope) {
            this.jobScope = jobScope;
            return this;
        }

        public FileInfo build() {
            return new FileInfo(this);
        }
    }
}

