/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.backuprestore;

import com.atlassian.confluence.api.model.backuprestore.JobDetails;
import com.atlassian.confluence.api.model.backuprestore.JobStatistics;
import com.atlassian.confluence.api.model.backuprestore.SiteBackupSettings;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SiteBackupJobDetails
extends JobDetails {
    @JsonProperty
    private SiteBackupSettings jobSettings;
    @JsonProperty
    private JobStatistics statistics;

    public SiteBackupJobDetails() {
        super(SiteBackupJobDetails.builder());
    }

    private SiteBackupJobDetails(SiteBackupJobDetailsBuilder builder) {
        super(builder);
        this.jobSettings = builder.jobSettings;
        this.statistics = builder.statistics;
    }

    public SiteBackupSettings getJobSettings() {
        return this.jobSettings;
    }

    public JobStatistics getJobStatistics() {
        return this.statistics;
    }

    public void setJobSettings(SiteBackupSettings jobSettings) {
        this.jobSettings = jobSettings;
    }

    public void setJobStatistics(JobStatistics jobStatistics) {
        this.statistics = jobStatistics;
    }

    public static SiteBackupJobDetailsBuilder builder() {
        return new SiteBackupJobDetailsBuilder();
    }

    public static class SiteBackupJobDetailsBuilder
    extends JobDetails.JobDetailsBuilder {
        private SiteBackupSettings jobSettings;
        private JobStatistics statistics;

        public SiteBackupJobDetailsBuilder jobSettings(SiteBackupSettings jobSettings) {
            this.jobSettings = new SiteBackupSettings(jobSettings.isSkipAttachments(), jobSettings.isKeepPermanently(), jobSettings.getFileNamePrefix());
            return this;
        }

        public SiteBackupJobDetailsBuilder jobStatistics(JobStatistics jobStatistics) {
            this.statistics = new JobStatistics(jobStatistics.getTotalObjectsCount(), jobStatistics.getProcessedObjectsCount(), jobStatistics.getPersistedObjectsCount(), jobStatistics.getSkippedObjectsCount(), jobStatistics.getReusedObjectsCount());
            return this;
        }

        @Override
        public SiteBackupJobDetails build() {
            return new SiteBackupJobDetails(this);
        }
    }
}

