/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.content;

import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.api.serialization.RestEnrichable;
import com.atlassian.sal.api.user.UserKey;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.stream.Collectors;

@RestEnrichable
@JsonIgnoreProperties(ignoreUnknown=true)
public class ContributorUsers {
    @JsonProperty
    @Schema
    private final List<Person> users;
    @JsonProperty
    @Schema(example="userKey1")
    private final List<String> userKeys;

    @JsonCreator
    private ContributorUsers() {
        this(ContributorUsers.builder());
    }

    private ContributorUsers(Builder builder) {
        this.users = builder.users;
        this.userKeys = builder.userKeys != null ? builder.userKeys.stream().map(UserKey::getStringValue).collect(Collectors.toList()) : null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<Person> getUsers() {
        return this.users;
    }

    public List<String> getUserKeys() {
        return this.userKeys;
    }

    public static class Builder {
        private List<Person> users;
        private List<UserKey> userKeys;

        private Builder() {
        }

        public Builder users(List<Person> users) {
            this.users = users;
            return this;
        }

        public Builder userKeys(List<UserKey> userKeys) {
            this.userKeys = userKeys;
            return this;
        }

        public ContributorUsers build() {
            return new ContributorUsers(this);
        }
    }

    public static class Expansions {
        public static final String USERS = "users";
    }
}

