/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.content;

import com.atlassian.confluence.api.model.content.ContentRepresentation;
import com.atlassian.confluence.api.model.content.FormattedBody;
import com.atlassian.confluence.api.model.content.webresource.WebResourceDependencies;
import com.atlassian.confluence.api.model.reference.BuilderUtils;
import com.atlassian.confluence.api.model.reference.EnrichableMap;
import com.atlassian.confluence.api.model.reference.ModelMapBuilder;
import com.atlassian.confluence.api.model.reference.Reference;
import com.atlassian.graphql.annotations.GraphQLTypeName;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PersonalSpaceDetailsForCreation {
    @JsonDeserialize(as=EnrichableMap.class)
    @JsonProperty
    @GraphQLTypeName(value="SpaceDescriptions")
    private Map<ContentRepresentation, FormattedBody> description;
    @JsonProperty
    @Schema(example="true")
    private boolean isPrivate;

    @JsonCreator
    private PersonalSpaceDetailsForCreation() {
        this(PersonalSpaceDetailsForCreation.builder());
    }

    private PersonalSpaceDetailsForCreation(PersonalSpaceDetailsForCreationBuilder builder) {
        this.description = BuilderUtils.modelMap(builder.description);
        this.isPrivate = builder.isPrivate;
    }

    public Map<ContentRepresentation, FormattedBody> getDescription() {
        return this.description;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public static PersonalSpaceDetailsForCreationBuilder builder() {
        return new PersonalSpaceDetailsForCreationBuilder();
    }

    public static PersonalSpaceDetailsForCreationBuilder builder(PersonalSpaceDetailsForCreation spaceDetails) {
        return PersonalSpaceDetailsForCreation.builder().description(spaceDetails.description).isPrivate(spaceDetails.isPrivate);
    }

    public static class PersonalSpaceDetailsForCreationBuilder {
        private ModelMapBuilder<ContentRepresentation, FormattedBody> description = ModelMapBuilder.newInstance();
        private boolean isPrivate;

        public PersonalSpaceDetailsForCreationBuilder description(ContentRepresentation representation, String value) {
            return this.description(representation, ((FormattedBody.FormattedBodyBuilder)((FormattedBody.FormattedBodyBuilder)((FormattedBody.FormattedBodyBuilder)FormattedBody.builder().representation(representation)).value(value)).webresource((Reference)Reference.empty(WebResourceDependencies.class))).build());
        }

        public PersonalSpaceDetailsForCreationBuilder description(ContentRepresentation representation, FormattedBody formattedBody) {
            this.description.put(representation, formattedBody);
            return this;
        }

        public PersonalSpaceDetailsForCreationBuilder description(Map<ContentRepresentation, FormattedBody> description) {
            this.description.copy(description);
            return this;
        }

        public PersonalSpaceDetailsForCreationBuilder isPrivate(boolean isPrivate) {
            this.isPrivate = isPrivate;
            return this;
        }

        public PersonalSpaceDetailsForCreation build() {
            return new PersonalSpaceDetailsForCreation(this);
        }
    }
}

