/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.content;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.api.model.reference.ExpandedReference;
import com.atlassian.confluence.api.model.reference.Reference;
import com.atlassian.confluence.api.nav.Navigation;
import com.atlassian.confluence.api.nav.NavigationAware;
import com.atlassian.confluence.api.nav.NavigationService;
import com.atlassian.confluence.api.serialization.RestEnrichable;
import com.atlassian.confluence.api.serialization.SwaggerEnrichExpandable;
import com.atlassian.confluence.api.serialization.SwaggerEnrichLinks;
import com.atlassian.confluence.api.serialization.jackson2.OffsetDateTimeDeserializer;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Date;
import java.util.Objects;

@RestEnrichable
@SwaggerEnrichExpandable
@SwaggerEnrichLinks
@JsonIgnoreProperties(ignoreUnknown=true)
public class Version
implements NavigationAware {
    @JsonProperty
    @Schema
    private final Person by;
    @JsonProperty
    @Schema(example="2020-01-01T00:00:00.000Z")
    @JsonDeserialize(using=OffsetDateTimeDeserializer.class)
    private final OffsetDateTime when;
    @JsonProperty
    @Schema(example="A message")
    private final String message;
    @JsonProperty
    @Schema(example="1")
    private final int number;
    @JsonProperty
    @Schema(example="true")
    private final boolean minorEdit;
    @JsonProperty
    @Schema(example="true")
    private final boolean hidden;
    @JsonProperty
    @Schema(example="123456")
    private final String syncRev;
    @JsonDeserialize(as=ExpandedReference.class, contentAs=Content.class)
    @JsonProperty
    @Schema
    private final Reference<Content> content;

    public static VersionBuilder builder() {
        return new VersionBuilder();
    }

    public static VersionBuilder builder(Version version) {
        return new VersionBuilder().by(version.by).message(version.message).minorEdit(version.minorEdit).hidden(version.hidden).number(version.number).when(version.when).syncRev(version.syncRev).content(version.content);
    }

    @Override
    public Navigation.Builder resolveNavigation(NavigationService navigationService) {
        if (!this.content.exists()) {
            return null;
        }
        return navigationService.createNavigation().experimental().content(this.content).version(this);
    }

    public static Reference<Version> buildReference(int number) {
        return Reference.collapsed(Version.class, Collections.singletonMap(IdProperties.number, number));
    }

    @Deprecated
    public static Reference<Version> buildReference(Reference<Content> contentRef, int number) {
        return Version.buildReference(number);
    }

    public static int getVersionNumber(Reference<Version> versionRef) {
        if (versionRef == null) {
            return 0;
        }
        Object numberProperty = versionRef.getIdProperty(IdProperties.number);
        if (numberProperty == null) {
            return 0;
        }
        return (Integer)numberProperty;
    }

    @JsonCreator
    private Version() {
        this(Version.builder());
    }

    private Version(VersionBuilder builder) {
        this.by = builder.by;
        this.when = builder.when;
        this.message = builder.message;
        this.number = builder.number;
        this.minorEdit = builder.minorEdit;
        this.hidden = builder.hidden;
        this.syncRev = builder.syncRev;
        this.content = Reference.orEmpty(builder.content, Content.class);
    }

    public Person getBy() {
        return this.by;
    }

    @JsonIgnore
    public OffsetDateTime getWhenAt() {
        return this.when;
    }

    public String getMessage() {
        return this.message;
    }

    public int getNumber() {
        return this.number;
    }

    public boolean isMinorEdit() {
        return this.minorEdit;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String getSyncRev() {
        return this.syncRev;
    }

    public VersionBuilder nextBuilder() {
        return Version.builder().number(this.number + 1);
    }

    public Reference<Content> getContentRef() {
        return this.content;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.number == version.number;
    }

    public int hashCode() {
        return Objects.hash(this.number);
    }

    public String toString() {
        return "Version{by=" + String.valueOf(this.by) + ", when=" + String.valueOf(this.when) + ", message='" + this.message + "', number=" + this.number + ", minorEdit=" + this.minorEdit + ", hidden=" + this.hidden + ", syncRev='" + this.syncRev + "', content=" + String.valueOf(this.content) + "}";
    }

    public static class VersionBuilder {
        private Person by;
        private OffsetDateTime when;
        private String message;
        private int number;
        private boolean minorEdit;
        private boolean hidden;
        private String syncRev;
        private Reference<Content> content = Reference.empty(Content.class);

        private VersionBuilder() {
        }

        public Version build() {
            return new Version(this);
        }

        public VersionBuilder by(Person by) {
            this.by = by;
            return this;
        }

        public VersionBuilder when(Date when) {
            if (when != null) {
                this.when = OffsetDateTime.ofInstant(when.toInstant(), ZoneId.systemDefault());
            }
            return this;
        }

        public VersionBuilder when(OffsetDateTime when) {
            this.when = when;
            return this;
        }

        public VersionBuilder message(String message) {
            this.message = message;
            return this;
        }

        public VersionBuilder number(int number) {
            this.number = number;
            return this;
        }

        public VersionBuilder minorEdit(boolean minorEdit) {
            this.minorEdit = minorEdit;
            return this;
        }

        public VersionBuilder hidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public VersionBuilder syncRev(String syncRev) {
            this.syncRev = syncRev;
            return this;
        }

        public VersionBuilder content(Reference<Content> content) {
            this.content = content;
            return this;
        }
    }

    static enum IdProperties {
        number;

    }

    public static class Expansions {
        public static final String BY = "by";
        public static final String CONTENT = "content";
    }
}

